/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.command;

import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.reward.RewardManager;
import com.hrznstudio.titanium.reward.RewardSyncMessage;
import com.hrznstudio.titanium.reward.storage.RewardWorldStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;

public class RewardCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"titanium-rewards").then(Commands.func_197056_a((String)"action", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> ISuggestionProvider.func_197008_a((String[])new String[]{"enable", "disable"}, (SuggestionsBuilder)builder)).then(Commands.func_197056_a((String)"reward", (ArgumentType)new ResourceLocationArgument()).suggests((context, builder) -> ISuggestionProvider.func_197013_a(RewardCommand.getAvailableResourceLocations((CommandContext<CommandSource>)context).stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder)).then(Commands.func_197056_a((String)"option", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> ISuggestionProvider.func_197008_a((String[])RewardManager.get().getReward((ResourceLocation)context.getArgument("reward", ResourceLocation.class)).getOptions(), (SuggestionsBuilder)builder)).executes(context -> {
            RewardCommand.execute((CommandContext<CommandSource>)context);
            return 1;
        })))));
    }

    private static void execute(CommandContext<CommandSource> context) {
        boolean changed = false;
        changed = ((String)context.getArgument("action", String.class)).equalsIgnoreCase("enable") ? RewardCommand.addReward(context) : RewardCommand.removeReward(context);
        if (changed) {
            ((CommandSource)context.getSource()).func_197028_i().execute(() -> {
                CompoundNBT nbt = RewardWorldStorage.get(((CommandSource)context.getSource()).func_197028_i().func_71218_a(World.field_234918_g_)).serializeSimple();
                ((CommandSource)context.getSource()).func_197028_i().func_184103_al().func_181057_v().forEach(serverPlayerEntity -> Titanium.NETWORK.get().sendTo((Object)new RewardSyncMessage(nbt), serverPlayerEntity.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT));
            });
        }
    }

    private static boolean removeReward(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        RewardWorldStorage rewardWorldStorage = RewardWorldStorage.get(source.func_197023_e());
        try {
            rewardWorldStorage.remove(source.func_197035_h().func_110124_au(), (ResourceLocation)context.getArgument("reward", ResourceLocation.class));
            rewardWorldStorage.func_76185_a();
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("titanium.rewards.remove_success"), true);
            return true;
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean addReward(CommandContext<CommandSource> context) {
        try {
            CommandSource source = (CommandSource)context.getSource();
            ResourceLocation resourceLocation = (ResourceLocation)context.getArgument("reward", ResourceLocation.class);
            if (RewardManager.get().getReward(resourceLocation) == null || !RewardManager.get().getReward(resourceLocation).isPlayerValid(source.func_197035_h().func_110124_au())) {
                return false;
            }
            RewardWorldStorage rewardWorldStorage = RewardWorldStorage.get(source.func_197023_e());
            rewardWorldStorage.add(source.func_197035_h().func_110124_au(), (ResourceLocation)context.getArgument("reward", ResourceLocation.class), (String)context.getArgument("option", String.class));
            rewardWorldStorage.func_76185_a();
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("titanium.rewards.enabled_success"), true);
            return true;
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static List<ResourceLocation> getAvailableResourceLocations(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        RewardWorldStorage rewardWorldStorage = RewardWorldStorage.get(source.func_197023_e());
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>(rewardWorldStorage.getFreeRewards());
        try {
            resourceLocations.addAll(RewardManager.get().collectRewardsResourceLocations(((CommandSource)context.getSource()).func_197035_h().func_110124_au()));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return resourceLocations;
    }
}

