/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.energy;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorageItemStack
implements IEnergyStorage {
    private static final String ENERGY = "stored";
    private static final String MAX = "max";
    private static final String INPUT = "in";
    private static final String OUTPUT = "out";
    private final ItemStack stack;

    public EnergyStorageItemStack(ItemStack stack, int capacity, int in, int out) {
        this.stack = stack;
        boolean hasTags = stack.func_77942_o();
        if (!hasTags || !stack.func_77978_p().func_74764_b("energy")) {
            if (!hasTags) {
                stack.func_77982_d(new CompoundNBT());
            }
            CompoundNBT tag = stack.func_77978_p();
            CompoundNBT energyTag = new CompoundNBT();
            energyTag.func_74768_a(ENERGY, 0);
            energyTag.func_74768_a(MAX, capacity);
            energyTag.func_74768_a(INPUT, in);
            energyTag.func_74768_a(OUTPUT, out);
            tag.func_218657_a("energy", (INBT)energyTag);
        } else {
            CompoundNBT energyTag = this.getStackEnergyTag();
            energyTag.func_74768_a(MAX, capacity);
            energyTag.func_74768_a(INPUT, in);
            energyTag.func_74768_a(OUTPUT, out);
        }
    }

    public void putInternal(int energy) {
        CompoundNBT energyTag = this.getStackEnergyTag();
        energyTag.func_74768_a(ENERGY, Math.min(energyTag.func_74762_e(ENERGY) + energy, energyTag.func_74762_e(MAX)));
    }

    private CompoundNBT getStackEnergyTag() {
        return this.stack.func_179543_a("energy");
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.getMaxReceive(), maxReceive));
        if (!simulate && energyReceived != 0) {
            this.getStackEnergyTag().func_74768_a("energy", this.getEnergyStored() + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.getMaxExtract(), maxExtract));
        if (!simulate && this.stack != null && energyExtracted != 0) {
            this.getStackEnergyTag().func_74768_a("energy", this.getEnergyStored() - energyExtracted);
        }
        return energyExtracted;
    }

    public int getMaxExtract() {
        return this.getStackEnergyTag().func_74762_e(OUTPUT);
    }

    public int getMaxReceive() {
        return this.getStackEnergyTag().func_74762_e(INPUT);
    }

    public int getEnergyStored() {
        return this.getStackEnergyTag().func_74762_e(ENERGY);
    }

    public int getMaxEnergyStored() {
        return this.getStackEnergyTag().func_74762_e(MAX);
    }

    public boolean canExtract() {
        return this.getMaxExtract() > 0;
    }

    public boolean canReceive() {
        return this.getMaxReceive() > 0;
    }
}

