/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend;

import fionathemortal.betterbiomeblend.BiomeCache;
import fionathemortal.betterbiomeblend.BlendCache;
import fionathemortal.betterbiomeblend.ColorBlending;
import fionathemortal.betterbiomeblend.ColorCache;
import fionathemortal.betterbiomeblend.ColorChunk;
import net.minecraft.world.World;
import net.minecraft.world.level.ColorResolver;

public final class ColorCaching {
    public static final int INVALID_CHUNK_KEY = -1;

    public static long getChunkKey(int chunkX, int chunkZ, int colorType) {
        long result = ((long)chunkZ & 0x3FFFFFFL) << 26 | (long)chunkX & 0x3FFFFFFL | (long)colorType << 52;
        return result;
    }

    public static ColorChunk getThreadLocalChunk(ThreadLocal<ColorChunk> threadLocal, int chunkX, int chunkZ, int colorType) {
        ColorChunk result = null;
        ColorChunk local = threadLocal.get();
        long key = ColorCaching.getChunkKey(chunkX, chunkZ, colorType);
        if (local.key == key) {
            result = local;
        }
        return result;
    }

    public static void setThreadLocalChunk(ThreadLocal<ColorChunk> threadLocal, ColorChunk chunk, BlendCache cache) {
        ColorChunk local = threadLocal.get();
        cache.releaseChunk(local);
        threadLocal.set(chunk);
    }

    public static ColorChunk getBlendedColorChunk(World world, ColorResolver colorResolverIn, int colorType, int chunkX, int chunkZ, BlendCache blendCache, ColorCache colorCache, BiomeCache biomeCache) {
        ColorChunk chunk = blendCache.getChunk(chunkX, chunkZ, colorType);
        if (chunk == null) {
            chunk = blendCache.newChunk(chunkX, chunkZ, colorType);
            ColorBlending.generateBlendedColorChunk(world, colorResolverIn, colorType, chunkX, chunkZ, colorCache, biomeCache, chunk.data);
            chunk = blendCache.putChunk(chunk);
        }
        return chunk;
    }
}

