/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.itsmeow.betteranimalsplus.common.entity.EntityBarracuda;
import dev.itsmeow.betteranimalsplus.common.entity.EntityBear;
import dev.itsmeow.betteranimalsplus.common.entity.EntityBoar;
import dev.itsmeow.betteranimalsplus.common.entity.EntityCoyote;
import dev.itsmeow.betteranimalsplus.common.entity.EntityCrab;
import dev.itsmeow.betteranimalsplus.common.entity.EntityFeralWolf;
import dev.itsmeow.betteranimalsplus.common.entity.EntityLamprey;
import dev.itsmeow.betteranimalsplus.common.entity.EntityOctopus;
import dev.itsmeow.betteranimalsplus.common.entity.EntityPiranha;
import dev.itsmeow.betteranimalsplus.common.entity.EntitySquirrel;
import dev.itsmeow.betteranimalsplus.common.entity.util.IHaveHunger;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntitySharkBase;
import dev.itsmeow.betteranimalsplus.common.forge.CommonEventHandlerImpl;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IBucketable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModLootTables;
import dev.itsmeow.betteranimalsplus.init.ModTriggers;
import dev.itsmeow.betteranimalsplus.mixin.MobAccessor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.architectury.event.events.EntityEvent;
import me.shedaniel.architectury.event.events.InteractionEvent;
import me.shedaniel.architectury.registry.Registries;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.JukeboxTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class CommonEventHandler {
    public static final Set<Predicate<Entity>> NO_ATTACKED_DROPS = new HashSet<Predicate<Entity>>();
    public static final Multimap<ResourceLocation, ResourceLocation> LOOT_TABLE_INJECTIONS;

    public static void init() {
        EntityEvent.LIVING_DEATH.register(CommonEventHandler::entityDeath);
        EntityEvent.LIVING_ATTACK.register(CommonEventHandler::entityAttack);
        EntityEvent.ADD.register(CommonEventHandler::entityAdd);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(CommonEventHandler::rightClickBlock);
        InteractionEvent.RIGHT_CLICK_ITEM.register(CommonEventHandler::rightClickItem);
        CommonEventHandler.registerPlatformEvents();
    }

    public static ActionResultType entityDeath(LivingEntity entity, DamageSource source) {
        if (source.func_76364_f() instanceof EntityBoar && ModEntities.BOAR.getCustomConfiguration().getBoolean("nerf_options/breed_from_kill")) {
            EntityBoar boar = (EntityBoar)source.func_76364_f();
            boar.func_146082_f(null);
            BlockPos p = boar.func_233580_cy_();
            boar.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, (double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), 0.0, (double)0.05f, 0.0);
        } else if (source.func_76364_f() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)source.func_76364_f();
            if (entity instanceof EntityBear || entity instanceof PolarBearEntity) {
                if (player.func_184614_ca().func_190926_b()) {
                    ModTriggers.PUNCH_BEAR_DEATH.trigger(player);
                }
            } else if (entity instanceof EntitySquirrel && !player.func_192039_O().func_192747_a(player.field_71133_b.func_191949_aK().func_192778_a(new ResourceLocation("betteranimalsplus:squirrel_kill_100"))).func_192105_a()) {
                CommonEventHandler.setSquirrelKills((PlayerEntity)player, oldValue -> {
                    int newValue = oldValue + 1;
                    if (newValue > 100) {
                        newValue = 1;
                    }
                    if (ModTriggers.SQUIRREL_KILL_TRIGGERS.containsKey(newValue)) {
                        ModTriggers.SQUIRREL_KILL_TRIGGERS.get(newValue).trigger(player);
                    }
                    return newValue;
                });
            }
        } else if (source.func_76346_g() instanceof EntityOctopus) {
            PlayerEntity p;
            EntityOctopus octo = (EntityOctopus)source.func_76346_g();
            if (octo.friend != null && (p = octo.field_70170_p.func_217371_b(octo.friend)) instanceof ServerPlayerEntity && p.func_94060_bK() == entity) {
                ModTriggers.OCTOPUS_SAVE_PLAYER.trigger((ServerPlayerEntity)octo.field_70170_p.func_217371_b(octo.friend));
            }
        }
        if (source.func_76364_f() instanceof IHaveHunger) {
            ((IHaveHunger)source.func_76364_f()).resetHunger();
        }
        return ActionResultType.PASS;
    }

    public static ActionResultType rightClickBlock(PlayerEntity player, Hand hand, BlockPos pos, Direction direction) {
        TileEntity te;
        if (player.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150421_aI && player instanceof ServerPlayerEntity && (te = player.field_70170_p.func_175625_s(pos)) instanceof JukeboxTileEntity) {
            JukeboxTileEntity box = (JukeboxTileEntity)te;
            Item held = player.func_184586_b(hand).func_77973_b();
            Item boxItem = box.func_195537_c().func_77973_b();
            boolean added = box.func_195537_c().func_190926_b();
            CommonEventHandler.onDiskUse(added, (ServerPlayerEntity)player, added ? held : boxItem);
        }
        return ActionResultType.PASS;
    }

    public static ActionResult<ItemStack> rightClickItem(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ResourceLocation reg = Registries.get((String)"betteranimalsplus").get(Registry.field_239714_o_).getId((Object)stack.func_77973_b());
        if (reg != null && reg.func_110623_a().equals("portable_jukebox") && player instanceof ServerPlayerEntity && stack.func_179543_a("Disc") != null) {
            Item item = ItemStack.func_199557_a((CompoundNBT)stack.func_179543_a("Disc")).func_77973_b();
            CommonEventHandler.onDiskUse(player.func_213453_ef(), (ServerPlayerEntity)player, item);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    private static void onDiskUse(boolean added, ServerPlayerEntity player, Item item) {
        block5: {
            if (!(item instanceof MusicDiscItem)) break block5;
            if (added) {
                List crabs = player.func_130014_f_().func_217357_a(EntityCrab.class, player.func_174813_aQ().func_186662_g(50.0));
                if (crabs.size() > 0) {
                    ModTriggers.CRAB_DANCE.trigger(player);
                }
                for (EntityCrab crab : crabs) {
                    crab.crabRave();
                }
            } else {
                List crabs = player.func_130014_f_().func_217357_a(EntityCrab.class, player.func_174813_aQ().func_186662_g(100.0));
                for (EntityCrab crab : crabs) {
                    crab.unCrabRave();
                }
            }
        }
    }

    public static ActionResultType entityAttack(LivingEntity entity, DamageSource source, float damage) {
        if (source.func_76346_g() instanceof ServerPlayerEntity && (entity instanceof EntityBear || entity instanceof PolarBearEntity) && ((ServerPlayerEntity)source.func_76346_g()).func_184614_ca().func_190926_b()) {
            ModTriggers.PUNCH_BEAR.trigger((ServerPlayerEntity)source.func_76346_g());
        }
        return ActionResultType.PASS;
    }

    public static void modifyDropsList(Collection<ItemEntity> drops, DamageSource source, LivingEntity entity) {
        if (!(source.func_76346_g() == null || entity instanceof PlayerEntity || !NO_ATTACKED_DROPS.stream().anyMatch(predicate -> predicate.test(source.func_76346_g())) || source.func_76346_g() instanceof IBucketable && ((IBucketable)source.func_76346_g()).isFromContainer())) {
            drops.clear();
        }
    }

    public static ActionResultType entityAdd(Entity entity, World level) {
        if (entity instanceof IronGolemEntity) {
            ((MobAccessor)entity).getTargetSelector().func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((IronGolemEntity)entity), EntityFeralWolf.class, 5, false, false, e -> !((EntityFeralWolf)e).func_70909_n()));
            ((MobAccessor)entity).getTargetSelector().func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((IronGolemEntity)entity), EntityCoyote.class, 5, false, false, e -> !((EntityCoyote)e).func_70909_n() && !((EntityCoyote)e).isDaytime()));
        }
        return ActionResultType.PASS;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerPlatformEvents() {
        CommonEventHandlerImpl.registerPlatformEvents();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setSquirrelKills(PlayerEntity player, int kills) {
        void var1_1;
        CommonEventHandlerImpl.setSquirrelKills(player, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setSquirrelKills(PlayerEntity player, Function<Integer, Integer> mutator) {
        void var1_1;
        CommonEventHandlerImpl.setSquirrelKills(player, (Function<Integer, Integer>)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getSquirrelKills(PlayerEntity player) {
        return CommonEventHandlerImpl.getSquirrelKills(player);
    }

    static {
        NO_ATTACKED_DROPS.add(e -> e instanceof EntityLamprey);
        NO_ATTACKED_DROPS.add(e -> e instanceof EntitySharkBase);
        NO_ATTACKED_DROPS.add(e -> e instanceof EntityBarracuda);
        NO_ATTACKED_DROPS.add(e -> e instanceof EntityPiranha);
        NO_ATTACKED_DROPS.add(e -> e instanceof EntityOctopus && ((EntityOctopus)e).friend == null);
        LOOT_TABLE_INJECTIONS = MultimapBuilder.hashKeys().hashSetValues().build();
        IVariant v = ModEntities.FERAL_WOLF.getVariantForName("snowy").orElse(null);
        if (v instanceof EntityFeralWolf.WolfVariant) {
            EntityFeralWolf.WolfVariant variant = (EntityFeralWolf.WolfVariant)v;
            LOOT_TABLE_INJECTIONS.put((Object)EntityType.field_200724_aC.func_220348_g(), (Object)variant.getLootTable());
        }
        LOOT_TABLE_INJECTIONS.put((Object)EntityType.field_200749_ao.func_220348_g(), (Object)ModLootTables.SQUID);
    }
}

