/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.EntityBearNeutral;
import dev.itsmeow.betteranimalsplus.common.entity.EntityDeer;
import dev.itsmeow.betteranimalsplus.common.entity.EntityPheasant;
import dev.itsmeow.betteranimalsplus.common.entity.ai.EntityAIEatBerries;
import dev.itsmeow.betteranimalsplus.common.entity.ai.FollowParentGoalButNotStupid;
import dev.itsmeow.betteranimalsplus.common.entity.ai.HungerNearestAttackableTargetGoal;
import dev.itsmeow.betteranimalsplus.common.entity.util.IDropHead;
import dev.itsmeow.betteranimalsplus.common.entity.util.IHaveHunger;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModLootTables;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.fish.SalmonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityBear
extends AnimalEntity
implements IDropHead<EntityBear>,
IHaveHunger<EntityBear> {
    private static final DataParameter<Boolean> IS_STANDING = EntityDataManager.func_187226_a(EntityBear.class, (IDataSerializer)DataSerializers.field_187198_h);
    private float clientSideStandAnimation0;
    private float clientSideStandAnimation;
    private int warningSoundTicks;
    private int hunger;

    public EntityBear(EntityType<? extends EntityBear> entityType, World worldIn) {
        super(entityType, worldIn);
        this.func_184644_a(PathNodeType.DANGER_OTHER, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_OTHER, 0.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BearMeleeAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new BearPanicGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowParentGoalButNotStupid(this, 1.25, e -> !(e instanceof EntityBearNeutral)));
        this.field_70714_bg.func_75776_a(3, (Goal)new EntityAIEatBerries((CreatureEntity)this, 1.0, 12, 2));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new BearHurtByTargetGoal());
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal());
        this.field_70715_bh.func_75776_a(2, new HungerNearestAttackableTargetGoal<SalmonEntity, EntityBear>(this, SalmonEntity.class, 90, true, true, e -> true));
        this.field_70715_bh.func_75776_a(3, new HungerNearestAttackableTargetGoal<EntityDeer, EntityBear>(this, EntityDeer.class, 90, true, true, e -> true));
        this.field_70715_bh.func_75776_a(4, new HungerNearestAttackableTargetGoal<PigEntity, EntityBear>(this, PigEntity.class, 90, true, true, e -> true));
        this.field_70715_bh.func_75776_a(5, new HungerNearestAttackableTargetGoal<ChickenEntity, EntityBear>(this, ChickenEntity.class, 90, true, true, e -> true));
        this.field_70715_bh.func_75776_a(6, new HungerNearestAttackableTargetGoal<RabbitEntity, EntityBear>(this, RabbitEntity.class, 90, true, true, e -> true));
        this.field_70715_bh.func_75776_a(5, new HungerNearestAttackableTargetGoal<EntityPheasant, EntityBear>(this, EntityPheasant.class, 90, true, true, e -> true));
        this.field_70715_bh.func_75776_a(3, new HungerNearestAttackableTargetGoal<FoxEntity, EntityBear>(this, FoxEntity.class, 90, true, true, e -> true));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new GroundPathNavigator((MobEntity)this, worldIn){

            protected void func_75508_h() {
                boolean flag;
                Vector3d vector3d = this.func_75502_i();
                this.field_188561_o = this.field_75515_a.func_213311_cf() > 0.75f ? this.field_75515_a.func_213311_cf() / 2.0f : 0.75f - this.field_75515_a.func_213311_cf() / 2.0f;
                BlockPos vector3i = this.field_75514_c.func_242948_g();
                double d0 = Math.abs(this.field_75515_a.func_226277_ct_() - ((double)vector3i.func_177958_n() + (double)(this.field_75515_a.func_213311_cf() + 1.0f) / 2.0));
                double d1 = Math.abs(this.field_75515_a.func_226278_cu_() - (double)vector3i.func_177956_o());
                double d2 = Math.abs(this.field_75515_a.func_226281_cx_() - ((double)vector3i.func_177952_p() + (double)(this.field_75515_a.func_213311_cf() + 1.0f) / 2.0));
                boolean bl = flag = d0 <= (double)this.field_188561_o && d2 <= (double)this.field_188561_o && d1 < 1.0;
                if (flag || this.field_75515_a.func_233660_b_(this.field_75514_c.func_237225_h_().field_186287_m) && this.shouldTargetNextNodeInDirection(vector3d)) {
                    this.field_75514_c.func_75875_a();
                }
                this.func_179677_a(vector3d);
            }

            private boolean shouldTargetNextNodeInDirection(Vector3d currentPosition) {
                Vector3d vector3d3;
                if (this.field_75514_c.func_75873_e() + 1 >= this.field_75514_c.func_75874_d()) {
                    return false;
                }
                Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)this.field_75514_c.func_242948_g());
                if (!currentPosition.func_237488_a_((IPosition)vector3d, 2.0)) {
                    return false;
                }
                Vector3d vector3d1 = Vector3d.func_237492_c_((Vector3i)this.field_75514_c.func_242947_d(this.field_75514_c.func_75873_e() + 1));
                Vector3d vector3d2 = vector3d1.func_178788_d(vector3d);
                return vector3d2.func_72430_b(vector3d3 = currentPosition.func_178788_d(vector3d)) > 0.0;
            }
        };
    }

    @Override
    public int getHunger() {
        return this.hunger;
    }

    @Override
    public void setHunger(int hunger) {
        this.hunger = hunger;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.writeHunger(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.readHunger(compound);
    }

    public boolean func_70877_b(ItemStack stack) {
        return ItemTags.field_206964_G.func_230235_a_((Object)stack.func_77973_b()) || stack.func_77973_b().func_219971_r() && stack.func_77973_b().func_219967_s().func_221467_c();
    }

    public boolean isPeaceful() {
        return this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL;
    }

    public double func_233579_cu_() {
        return 0.6;
    }

    protected ResourceLocation func_184647_J() {
        return ModLootTables.BEAR_BROWN;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 20 == 0) {
            this.incrementHunger();
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.clientSideStandAnimation != this.clientSideStandAnimation0) {
                this.func_213323_x_();
            }
            this.clientSideStandAnimation0 = this.clientSideStandAnimation;
            this.clientSideStandAnimation = this.isStanding() ? MathHelper.func_76131_a((float)(this.clientSideStandAnimation + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.clientSideStandAnimation - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STANDING);
    }

    public void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(IS_STANDING, (Object)standing);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getStandingAnimationScale(float p_189795_1_) {
        return MathHelper.func_219799_g((float)p_189795_1_, (float)this.clientSideStandAnimation0, (float)this.clientSideStandAnimation) / 6.0f;
    }

    protected float func_189749_co() {
        return 0.97f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.clientSideStandAnimation > 0.0f) {
            float f = this.clientSideStandAnimation / 6.0f;
            float f1 = 1.0f + f;
            return super.func_213305_a(poseIn).func_220312_a(1.0f, f1);
        }
        return super.func_213305_a(poseIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundEvents.field_190031_ew, 1.0f, 1.0f);
            this.warningSoundTicks = 40;
        }
    }

    protected SoundEvent func_184639_G() {
        return this.func_70631_g_() ? SoundEvents.field_190027_es : SoundEvents.field_190026_er;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_190029_eu;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_STANDING, (Object)false);
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || source == DamageSource.field_220302_v;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.doHeadDrop();
    }

    public boolean func_213397_c(double range) {
        return this.despawn(range);
    }

    @Override
    public EntityBear getImplementation() {
        return this;
    }

    @Override
    public EntityTypeContainer<? extends EntityBear> getContainer() {
        return ModEntities.BROWN_BEAR;
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return (AgeableEntity)this.getContainer().getEntityType().func_200721_a((World)world);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.setInitialHunger();
        if (spawnDataIn instanceof GroupData) {
            this.func_70873_a(-24000);
        } else {
            spawnDataIn = new GroupData();
        }
        return spawnDataIn;
    }

    class BearMeleeAttackGoal
    extends MeleeAttackGoal {
        public BearMeleeAttackGoal() {
            super((CreatureEntity)EntityBear.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)enemy);
                EntityBear.this.setStanding(false);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.func_234040_h_()) {
                    EntityBear.this.setStanding(false);
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 10) {
                    EntityBear.this.setStanding(true);
                    EntityBear.this.playWarningSound();
                }
            } else {
                this.func_234039_g_();
                EntityBear.this.setStanding(false);
            }
        }

        public void func_75251_c() {
            EntityBear.this.setStanding(false);
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 8.0f + attackTarget.func_213311_cf();
        }
    }

    class BearPanicGoal
    extends PanicGoal {
        public BearPanicGoal() {
            super((CreatureEntity)EntityBear.this, 2.0);
        }

        public boolean func_75250_a() {
            return (EntityBear.this.func_70631_g_() || EntityBear.this.func_70027_ad()) && super.func_75250_a();
        }
    }

    class BearHurtByTargetGoal
    extends HurtByTargetGoal {
        public BearHurtByTargetGoal() {
            super((CreatureEntity)EntityBear.this, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (EntityBear.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (!(!(mobIn instanceof EntityBear) || mobIn.func_70631_g_() || targetIn instanceof PlayerEntity && ((EntityBear)mobIn).isPeaceful())) {
                super.func_220793_a(mobIn, targetIn);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super((MobEntity)EntityBear.this, PlayerEntity.class, 0, true, true, null);
        }

        public boolean func_75250_a() {
            if (EntityBear.this.isPeaceful() || EntityBear.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a()) {
                for (EntityBear bear : EntityBear.this.field_70170_p.func_217357_a(EntityBear.class, EntityBear.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                    if (!bear.func_70631_g_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }

    static class GroupData
    implements ILivingEntityData {
        private GroupData() {
        }
    }
}

