/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity.ai;

import dev.itsmeow.betteranimalsplus.util.ModPlatformEvents;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityAIEatGrassCustom
extends Goal {
    private static final Predicate<BlockState> IS_GRASS = BlockStateMatcher.func_177638_a((Block)Blocks.field_150349_c);
    protected final MobEntity eater;
    protected final World world;
    protected int eatingGrassTimer;
    protected final int childChance;
    protected final int adultChance;
    protected final Function<MobEntity, BlockPos> getPosition;

    public EntityAIEatGrassCustom(MobEntity eater, int childChance, int adultChance) {
        this(eater, childChance, adultChance, e -> new BlockPos(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_()));
    }

    public EntityAIEatGrassCustom(MobEntity eater, int childChance, int adultChance, Function<MobEntity, BlockPos> getPosition) {
        this.eater = eater;
        this.world = eater.field_70170_p;
        this.childChance = childChance;
        this.adultChance = adultChance;
        this.getPosition = getPosition;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean func_75250_a() {
        if (this.eater.func_70681_au().nextInt(this.eater.func_70631_g_() ? this.childChance : this.adultChance) == 0) {
            BlockPos blockpos = this.getPosition.apply(this.eater);
            return IS_GRASS.test(this.world.func_180495_p(blockpos)) || this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_196658_i;
        }
        return false;
    }

    public void func_75249_e() {
        this.eatingGrassTimer = 40;
        this.world.func_72960_a((Entity)this.eater, (byte)10);
        this.eater.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.eatingGrassTimer = 0;
    }

    public boolean func_75253_b() {
        return this.eatingGrassTimer > 0;
    }

    public int getEatingGrassTimer() {
        return this.eatingGrassTimer;
    }

    public void func_75246_d() {
        this.eatingGrassTimer = Math.max(0, this.eatingGrassTimer - 1);
        if (this.eatingGrassTimer == 4) {
            BlockPos blockpos = this.getPosition.apply(this.eater);
            if (IS_GRASS.test(this.world.func_180495_p(blockpos))) {
                if (ModPlatformEvents.mobGrief(this.world, this.eater)) {
                    this.world.func_175655_b(blockpos, false);
                }
                this.eater.func_70615_aA();
            } else {
                BlockPos blockpos1 = blockpos.func_177977_b();
                if (this.world.func_180495_p(blockpos1).func_177230_c() == Blocks.field_196658_i) {
                    if (ModPlatformEvents.mobGrief(this.world, this.eater)) {
                        this.world.func_217379_c(2001, blockpos1, Block.func_196246_j((BlockState)Blocks.field_196658_i.func_176223_P()));
                        this.world.func_180501_a(blockpos1, Blocks.field_150346_d.func_176223_P(), 2);
                    }
                    this.eater.func_70615_aA();
                }
            }
        }
    }
}

