/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity.util.abstracts;

import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathing;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EntityBAPCephalopod
extends EntityWaterMobPathing {
    public float squidPitch;
    public float prevSquidPitch;
    public float squidYaw;
    public float prevSquidYaw;
    public float squidRotation;
    public float prevSquidRotation;
    public float tentacleAngle;
    public float lastTentacleAngle;
    protected float rotationVelocity;
    protected float rotateSpeed;
    protected float randomMotionSpeed;
    protected float randomMotionVecX;
    protected float randomMotionVecY;
    protected float randomMotionVecZ;

    public EntityBAPCephalopod(EntityType<? extends WaterMobEntity> type, World world) {
        super(type, world);
        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.05f;
    }

    public void func_70624_b(LivingEntity entitylivingbaseIn) {
        if (!this.isPeaceful()) {
            super.func_70624_b(entitylivingbaseIn);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevSquidPitch = this.squidPitch;
        this.prevSquidYaw = this.squidYaw;
        this.prevSquidRotation = this.squidRotation;
        this.lastTentacleAngle = this.tentacleAngle;
        this.squidRotation += this.rotationVelocity;
        if ((double)this.squidRotation > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.squidRotation = (float)Math.PI * 2;
            } else {
                this.squidRotation = (float)((double)this.squidRotation - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
            }
        }
        if (this.func_203005_aq()) {
            if (this.squidRotation < (float)Math.PI) {
                float f = this.squidRotation / (float)Math.PI;
                this.tentacleAngle = MathHelper.func_76126_a((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K && this.func_70661_as().func_75500_f()) {
                this.func_213293_j(this.randomMotionVecX * this.randomMotionSpeed, this.randomMotionVecY * this.randomMotionSpeed, this.randomMotionVecZ * this.randomMotionSpeed);
            }
            Vector3d vec3d = this.func_213322_ci();
            float f1 = MathHelper.func_76133_a((double)EntityBAPCephalopod.func_213296_b((Vector3d)vec3d));
            this.field_70761_aq += (-((float)MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c)) * 57.295776f - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.squidYaw = (float)((double)this.squidYaw + Math.PI * (double)this.rotateSpeed * 1.5);
            this.squidPitch += (-((float)MathHelper.func_181159_b((double)f1, (double)vec3d.field_72448_b)) * 57.295776f - this.squidPitch) * 0.1f;
        } else {
            this.tentacleAngle = MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)this.squidRotation)) * (float)Math.PI * 0.25f;
            if (!this.field_70170_p.field_72995_K) {
                double d0 = this.func_213322_ci().field_72448_b;
                if (this.func_70644_a(Effects.field_188424_y)) {
                    d0 = 0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1);
                } else if (!this.func_189652_ae()) {
                    d0 -= 0.08;
                }
                this.func_213293_j(0.0, d0 * (double)0.98f, 0.0);
            }
            this.squidPitch = (float)((double)this.squidPitch + (double)(-90.0f - this.squidPitch) * 0.02);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 19) {
            this.squidRotation = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            this.squirtInk();
            return true;
        }
        return false;
    }

    public boolean isPeaceful() {
        return this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.5f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187829_fQ;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187833_fS;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Vector3d getInkAngle(Vector3d vec) {
        Vector3d vec3d = vec.func_178789_a(this.prevSquidPitch * ((float)Math.PI / 180));
        vec3d = vec3d.func_178785_b(-this.field_70760_ar * ((float)Math.PI / 180));
        return vec3d;
    }

    protected void squirtInk() {
        this.func_184185_a(SoundEvents.field_203639_hT, this.func_70599_aP(), this.func_70647_i());
        Vector3d vec3d = this.getInkAngle(new Vector3d(0.0, -1.0, 0.0)).func_72441_c(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        for (int i = 0; i < 30; ++i) {
            Vector3d vec3d1 = this.getInkAngle(new Vector3d((double)this.field_70146_Z.nextFloat() * 0.6 - 0.3, -1.0, (double)this.field_70146_Z.nextFloat() * 0.6 - 0.3));
            Vector3d vec3d2 = vec3d1.func_186678_a(0.3 + (double)(this.field_70146_Z.nextFloat() * 2.0f));
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_203219_V, vec3d.field_72450_a, vec3d.field_72448_b + 0.5, vec3d.field_72449_c, 0, vec3d2.field_72450_a, vec3d2.field_72448_b, vec3d2.field_72449_c, (double)0.1f);
        }
    }

    public void setMovementVector(float x, float y, float z) {
        this.randomMotionVecX = x;
        this.randomMotionVecY = y;
        this.randomMotionVecZ = z;
    }

    public boolean hasMovementVector() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    public static class MoveRandomGoal
    extends Goal {
        private final EntityBAPCephalopod cephalopod;

        public MoveRandomGoal(EntityBAPCephalopod squid) {
            this.cephalopod = squid;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.cephalopod.func_70638_az() == null;
        }

        public boolean func_75253_b() {
            return this.cephalopod.func_70638_az() == null;
        }

        public void func_75246_d() {
            int i = this.cephalopod.func_70654_ax();
            if (i > 100) {
                this.cephalopod.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.cephalopod.func_70681_au().nextInt(50) == 0 || !this.cephalopod.field_70171_ac || !this.cephalopod.hasMovementVector()) {
                float f = this.cephalopod.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                float f1 = MathHelper.func_76134_b((float)f) * 0.2f;
                float f2 = -0.1f + this.cephalopod.func_70681_au().nextFloat() * 0.2f;
                float f3 = MathHelper.func_76126_a((float)f) * 0.2f;
                this.cephalopod.setMovementVector(f1, f2, f3);
            }
        }
    }
}

