/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.part.io;

import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.IIoEntity;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockPart;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullPredicate;

public abstract class AbstractIOPortHandler<Controller extends AbstractCuboidMultiblockController<Controller>, T extends AbstractMultiblockEntity<Controller>> {
    private final T _part;
    private final IoMode _mode;

    public T getPart() {
        return this._part;
    }

    public boolean isInput() {
        return ((IIoEntity)this.getPart()).getIoDirection().isInput();
    }

    public boolean isOutput() {
        return ((IIoEntity)this.getPart()).getIoDirection().isOutput();
    }

    public boolean isActive() {
        return this._mode.isActive();
    }

    public boolean isPassive() {
        return this._mode.isPassive();
    }

    protected AbstractIOPortHandler(T part, IoMode mode) {
        this._part = part;
        this._mode = mode;
    }

    @Nullable
    protected <C> C lookupConsumer(@Nullable World world, BlockPos position, @Nullable Capability<C> requestedCapability, NonNullPredicate<TileEntity> isSameHandler, @Nullable C currentConsumer) {
        boolean isConnectedNow;
        LazyOptional capability;
        TileEntity te;
        if (null == world) {
            return null;
        }
        boolean wasConnected = null != currentConsumer;
        Object foundConsumer = null;
        Direction approachDirection = ((AbstractCuboidMultiblockPart)this.getPart()).getOutwardDirection().orElse(null);
        if (null == approachDirection) {
            wasConnected = false;
        } else if (null != requestedCapability && null != (te = WorldHelper.getLoadedTile((IWorldReader)world, position.func_177972_a(approachDirection))) && !isSameHandler.test((Object)te) && (capability = te.getCapability(requestedCapability, approachDirection.func_176734_d())).isPresent()) {
            foundConsumer = capability.orElseThrow(RuntimeException::new);
        }
        boolean bl = isConnectedNow = null != foundConsumer;
        if (wasConnected != isConnectedNow && CodeHelper.calledByLogicalClient(world)) {
            WorldHelper.notifyBlockUpdate(world, position, null, null);
        }
        return (C)foundConsumer;
    }
}

