/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal;

import it.zerono.mods.zerocore.internal.MultiblockRegistrySafeReferent;
import it.zerono.mods.zerocore.internal.network.Network;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockRegistry;
import it.zerono.mods.zerocore.lib.recipe.ModRecipeType;
import java.util.concurrent.CompletableFuture;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

public final class Lib {
    public static final String NAME_RESULT = "result";
    public static final String NAME_INGREDIENT = "ingredient";
    public static final String NAME_ITEM = "item";
    public static final String NAME_FLUID = "fluid";
    public static final String NAME_TAG = "tag";
    public static final String NAME_COUNT = "count";
    public static final String NAME_NBT_TAG = "nbt";
    public static final String NAME_TYPE = "type";
    public static final String NAME_CONDITIONS = "conditions";
    private static boolean s_resourceReloaded;

    public static void initialize() {
        s_resourceReloaded = false;
        IEventBus bus = (IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get();
        bus.addGenericListener(IRecipeSerializer.class, Lib::onRegisterRecipeSerializer);
        bus = (IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get();
        bus.addListener(Lib::onAddReloadListener);
        bus.addListener(Lib::onWorldTick);
    }

    public static boolean shouldInvalidateResourceCache() {
        return s_resourceReloaded;
    }

    public static <Controller extends IMultiblockController<Controller>> IMultiblockRegistry<Controller> createMultiblockRegistry() {
        return (IMultiblockRegistry)DistExecutor.safeRunForDist(() -> MultiblockRegistrySafeReferent::client, () -> MultiblockRegistrySafeReferent::server);
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> CompletableFuture.runAsync(() -> {
            s_resourceReloaded = true;
            ModRecipeType.invalidate();
            Network.sendClearRecipeCommand();
        }, gameExecutor).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0)));
    }

    @SubscribeEvent
    public static void onRegisterRecipeSerializer(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        ModRecipeType.onRegisterRecipes();
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side.isServer() && TickEvent.Phase.END == event.phase) {
            s_resourceReloaded = false;
        }
    }

    private Lib() {
    }
}

