/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.proxy;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.zerono.mods.zerocore.internal.InternalCommand;
import it.zerono.mods.zerocore.internal.client.RenderTypes;
import it.zerono.mods.zerocore.internal.proxy.GuiErrorData;
import it.zerono.mods.zerocore.internal.proxy.IProxy;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.GuiHelper;
import it.zerono.mods.zerocore.lib.client.gui.IRichText;
import it.zerono.mods.zerocore.lib.client.gui.sprite.AtlasSpriteSupplier;
import it.zerono.mods.zerocore.lib.client.model.BakedModelSupplier;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.recipe.ModRecipeType;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;

public class ClientProxy
implements IProxy {
    private static final Colour ERROR_BACKGROUND_COLOUR = Colour.fromARGB(0x5F5E5E5E);
    private static final Colour ERROR_HIGHLIGHT1_COLOUR = Colour.fromARGB(1357442637);
    private static final Colour ERROR_HIGHLIGHT2_COLOUR = Colour.fromARGB(1349809958);
    private static final int ERROR_BORDER = 5;
    private static volatile long s_lastRenderTime = System.currentTimeMillis();
    private final GuiErrorData _guiErrorData = new GuiErrorData();

    public ClientProxy() {
        IEventBus modBus = (IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get();
        modBus.register((Object)this);
        modBus.register((Object)BakedModelSupplier.INSTANCE);
        modBus.register((Object)AtlasSpriteSupplier.INSTANCE);
        IEventBus forgeBus = (IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get();
        forgeBus.addListener(this::onRenderTick);
        forgeBus.addListener(EventPriority.NORMAL, true, this::onGameOverlayRender);
        forgeBus.addListener(EventPriority.NORMAL, true, this::onGuiDrawScreenEventPost);
        forgeBus.addListener(EventPriority.NORMAL, true, this::onHighlightBlock);
    }

    @SubscribeEvent
    public void onClientInit(FMLClientSetupEvent event) {
        CodeHelper.addResourceReloadListener(AtlasSpriteSupplier.INSTANCE);
    }

    @Override
    public Optional<World> getClientWorld() {
        return Optional.ofNullable(Minecraft.func_71410_x().field_71441_e);
    }

    @Override
    public Optional<PlayerEntity> getClientPlayer() {
        return Optional.ofNullable(Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    public void markBlockRangeForRenderUpdate(BlockPos min, BlockPos max) {
        Minecraft.func_71410_x().field_71438_f.func_147585_a(min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p());
    }

    @Override
    public void sendPlayerStatusMessage(PlayerEntity player, ITextComponent message) {
        Minecraft.func_71410_x().field_71456_v.func_175188_a(message, false);
    }

    @Override
    public void addResourceReloadListener(ISelectiveResourceReloadListener listener) {
        Minecraft mc = Minecraft.func_71410_x();
        if (null != mc && mc.func_195551_G() instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)listener);
        }
    }

    @Override
    public long getLastRenderTime() {
        return s_lastRenderTime;
    }

    @Override
    public void reportErrorToPlayer(@Nullable PlayerEntity player, @Nullable BlockPos position, ITextComponent ... messages) {
        this._guiErrorData.addErrors(position, messages);
    }

    @Override
    public void reportErrorToPlayer(@Nullable PlayerEntity player, @Nullable BlockPos position, List<ITextComponent> messages) {
        this._guiErrorData.addErrors(position, messages);
    }

    @Override
    public void clearErrorReport() {
        this._guiErrorData.resetErrors();
    }

    @Override
    public RecipeManager getRecipeManager() {
        if (EffectiveSide.get().isClient()) {
            ClientPlayNetHandler handler = Minecraft.func_71410_x().func_147114_u();
            return null != handler ? handler.func_199526_e() : null;
        }
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        return null != server ? server.func_199529_aN() : null;
    }

    @Override
    public void handleInternalCommand(InternalCommand command, CompoundNBT data, NetworkDirection direction) {
        switch (command) {
            case ClearRecipes: {
                ModRecipeType.invalidate();
                break;
            }
            case DebugGuiFrame: {
                GuiHelper.enableGuiDebugFrame(data.func_74764_b("enable") && data.func_74767_n("enable"));
                break;
            }
            case ContainerDataSync: {
                this.getClientPlayer().map(p -> p.field_71070_bA).filter(c -> c instanceof ModContainer).map(c -> (ModContainer)c).ifPresent(mc -> mc.onContainerDataSync(data));
                break;
            }
            default: {
                IProxy.super.handleInternalCommand(command, data, direction);
            }
        }
    }

    @Override
    public void debugUngrabMouse() {
        Minecraft.func_71410_x().field_71417_B.func_198032_j();
    }

    private void onRenderTick(TickEvent.RenderTickEvent event) {
        if (TickEvent.Phase.END == event.phase) {
            s_lastRenderTime = System.currentTimeMillis();
            this._guiErrorData.tick();
        }
    }

    private void onGameOverlayRender(RenderGameOverlayEvent.Post event) {
        if (!ClientProxy.isGuiOpen()) {
            this.paintErrorMessage(event.getMatrixStack());
        }
    }

    private void onGuiDrawScreenEventPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (ClientProxy.isGuiOpen()) {
            this.paintErrorMessage(event.getMatrixStack());
        }
    }

    private void onHighlightBlock(DrawHighlightEvent.HighlightBlock event) {
        BlockRayTraceResult result = event.getTarget();
        BlockPos position = result.func_216350_a();
        if (RayTraceResult.Type.BLOCK == result.func_216346_c() && this._guiErrorData.test(position)) {
            Vector3d projectedView = event.getInfo().func_216785_c();
            ModRenderHelper.paintVoxelShape(event.getMatrix(), VoxelShapes.func_197868_b(), event.getBuffers().getBuffer(RenderTypes.ERROR_BLOCK_HIGHLIGHT), (double)position.func_177958_n() - projectedView.func_82615_a(), (double)position.func_177956_o() - projectedView.func_82617_b(), (double)position.func_177952_p() - projectedView.func_82616_c(), ERROR_HIGHLIGHT1_COLOUR);
            event.setCanceled(true);
        }
    }

    private void paintErrorMessage(MatrixStack matrix) {
        IRichText texts = this._guiErrorData.apply(Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2);
        if (texts.isEmpty()) {
            return;
        }
        ModRenderHelper.paintMessage(matrix, texts, 5, 5, 300, 5, ERROR_BACKGROUND_COLOUR, ERROR_HIGHLIGHT1_COLOUR, ERROR_HIGHLIGHT2_COLOUR);
    }

    private static boolean isGuiOpen() {
        return null != Minecraft.func_71410_x().field_71462_r;
    }
}

