/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.proxy;

import com.google.common.collect.Lists;
import it.zerono.mods.zerocore.lib.client.gui.CompositeRichText;
import it.zerono.mods.zerocore.lib.client.gui.IRichText;
import it.zerono.mods.zerocore.lib.client.gui.RichText;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.functional.NonNullIntFunction;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Items;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

class GuiErrorData
implements Predicate<BlockPos>,
NonNullIntFunction<IRichText> {
    private final StampedLock _lock = new StampedLock();
    private final AtomicInteger _timeout = new AtomicInteger(0);
    private List<ITextComponent> _errorMessages;
    private BlockPos _errorPosition;
    private IRichText _errorText;

    public void tick() {
        if (this._timeout.get() > 0 && 0 == this._timeout.decrementAndGet()) {
            this.resetErrors();
        }
    }

    public void addErrors(@Nullable BlockPos position, ITextComponent ... messages) {
        this.addErrors(position, Lists.newArrayList((Object[])messages));
    }

    public void addErrors(@Nullable BlockPos position, List<ITextComponent> messages) {
        long stamp = this._lock.writeLock();
        this._timeout.set(6000);
        this._errorMessages = messages;
        this._errorPosition = position;
        this._errorText = null;
        this._lock.unlockWrite(stamp);
    }

    public void addErrors(ITextComponent ... messages) {
        this.addErrors((BlockPos)null, messages);
    }

    public void resetErrors() {
        long stamp = this._lock.writeLock();
        this._timeout.set(0);
        this._errorMessages = null;
        this._errorPosition = null;
        this._errorText = null;
        this._lock.unlockWrite(stamp);
    }

    @Override
    @Nonnull
    public IRichText apply(int maxTextWidth) {
        long lockStamp = this._lock.readLock();
        List<ITextComponent> errorMessages = this._errorMessages;
        if (null == errorMessages || errorMessages.isEmpty() || this._timeout.get() <= 0) {
            this._lock.unlockRead(lockStamp);
            return RichText.EMPTY;
        }
        IRichText texts = this._errorText;
        if (null == texts) {
            while (true) {
                long writeLockStamp;
                if (0L != (writeLockStamp = this._lock.tryConvertToWriteLock(lockStamp))) {
                    BlockPos errorPosition = this._errorPosition;
                    if (null == errorPosition && 1 == errorMessages.size()) {
                        texts = this._errorText = GuiErrorData.textFrom(errorMessages.get(0), maxTextWidth);
                    } else {
                        CompositeRichText.Builder builder = CompositeRichText.builder().interline(5);
                        if (null != errorPosition) {
                            builder.add(RichText.builder(maxTextWidth).textLines(Lists.newArrayList((Object[])new ITextComponent[]{new StringTextComponent(String.format("@0 %d, %d, %d", errorPosition.func_177958_n(), errorPosition.func_177956_o(), errorPosition.func_177952_p()))})).objects(Lists.newArrayList((Object[])new Object[]{Items.field_151111_aL})).defaultColour(Colour.WHITE).build());
                        }
                        errorMessages.forEach(message -> builder.add(GuiErrorData.textFrom(message, maxTextWidth)));
                        texts = this._errorText = builder.build();
                    }
                    lockStamp = writeLockStamp;
                    break;
                }
                this._lock.unlockRead(lockStamp);
                lockStamp = this._lock.writeLock();
            }
        }
        this._lock.unlock(lockStamp);
        return texts;
    }

    @Override
    public boolean test(BlockPos pos) {
        long stamp = this._lock.tryOptimisticRead();
        BlockPos errorPosition = this._errorPosition;
        if (!this._lock.validate(stamp)) {
            stamp = this._lock.readLock();
            errorPosition = this._errorPosition;
            this._lock.unlockRead(stamp);
        }
        return null != errorPosition && errorPosition.equals((Object)pos);
    }

    private static IRichText textFrom(ITextComponent errorMessage, int maxTextWidth) {
        return RichText.builder(maxTextWidth).textLines(errorMessage).defaultColour(Colour.WHITE).build();
    }
}

