/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block.multiblock;

import it.zerono.mods.zerocore.lib.block.multiblock.MultiblockPartBlock;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.common.util.NonNullSupplier;

public class MultiblockPartTypeProperties<Controller extends IMultiblockController<Controller>, PartType extends Enum<PartType>> {
    private final NonNullSupplier<NonNullSupplier<TileEntityType<?>>> _tileTypeSupplier;
    private final NonNullFunction<MultiblockPartBlock.MultiblockPartProperties<PartType>, MultiblockPartBlock<Controller, PartType>> _blockFactory;
    private final NonNullFunction<AbstractBlock.Properties, AbstractBlock.Properties> _blockPropertiesFixer;
    private final NonNullFunction<MultiblockPartBlock.MultiblockPartProperties<PartType>, MultiblockPartBlock.MultiblockPartProperties<PartType>> _extendedPropertiesFixer;
    private final String _translationKey;

    public MultiblockPartTypeProperties(NonNullSupplier<NonNullSupplier<TileEntityType<?>>> tileTypeSupplier, NonNullFunction<MultiblockPartBlock.MultiblockPartProperties<PartType>, MultiblockPartBlock<Controller, PartType>> blockFactory, String translationKey, NonNullFunction<AbstractBlock.Properties, AbstractBlock.Properties> blockPropertiesFixer) {
        this(tileTypeSupplier, blockFactory, translationKey, blockPropertiesFixer, ep -> ep);
    }

    public MultiblockPartTypeProperties(NonNullSupplier<NonNullSupplier<TileEntityType<?>>> tileTypeSupplier, NonNullFunction<MultiblockPartBlock.MultiblockPartProperties<PartType>, MultiblockPartBlock<Controller, PartType>> blockFactory, String translationKey, NonNullFunction<AbstractBlock.Properties, AbstractBlock.Properties> blockPropertiesFixer, NonNullFunction<MultiblockPartBlock.MultiblockPartProperties<PartType>, MultiblockPartBlock.MultiblockPartProperties<PartType>> partPropertiesFixer) {
        this._tileTypeSupplier = tileTypeSupplier;
        this._blockFactory = blockFactory;
        this._translationKey = translationKey;
        this._blockPropertiesFixer = blockPropertiesFixer;
        this._extendedPropertiesFixer = partPropertiesFixer;
    }

    public MultiblockPartBlock<Controller, PartType> createBlock(PartType type) {
        return (MultiblockPartBlock)this._blockFactory.apply(this._extendedPropertiesFixer.apply(MultiblockPartBlock.MultiblockPartProperties.create(type, (AbstractBlock.Properties)this._blockPropertiesFixer.apply((Object)IMultiblockPart.getDefaultBlockProperties()))));
    }

    public MultiblockPartBlock<Controller, PartType> createBlock(PartType type, IMultiblockVariant variant) {
        return (MultiblockPartBlock)this._blockFactory.apply(this._extendedPropertiesFixer.apply(MultiblockPartBlock.MultiblockPartProperties.create(type, (AbstractBlock.Properties)this._blockPropertiesFixer.apply((Object)variant.getDefaultBlockProperties())).variant(variant)));
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)((NonNullSupplier)this._tileTypeSupplier.get()).get()).func_200968_a();
    }

    public String getTranslationKey() {
        return this._translationKey;
    }
}

