/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render.buffer;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.zerono.mods.zerocore.lib.client.render.buffer.VertexBuilderWrapper;
import java.util.Objects;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.math.MathHelper;

public class TintingRenderTypeBufferWrapper
implements IRenderTypeBuffer {
    private final IRenderTypeBuffer _buffer;
    private final int _alpha;
    private final int _red;
    private final int _green;
    private final int _blue;

    public TintingRenderTypeBufferWrapper(IRenderTypeBuffer originalBuffer, int alpha, int redTint, int greenTint, int blueTint) {
        this._buffer = Objects.requireNonNull(originalBuffer);
        this._alpha = MathHelper.func_76125_a((int)alpha, (int)0, (int)255);
        this._red = MathHelper.func_76125_a((int)redTint, (int)0, (int)255);
        this._green = MathHelper.func_76125_a((int)greenTint, (int)0, (int)255);
        this._blue = MathHelper.func_76125_a((int)blueTint, (int)0, (int)255);
    }

    public TintingRenderTypeBufferWrapper(IRenderTypeBuffer originalBuffer, float alpha, float redTint, float greenTint, float blueTint) {
        this(originalBuffer, (int)(alpha * 255.0f), (int)(redTint * 255.0f), (int)(greenTint * 255.0f), (int)(blueTint * 255.0f));
    }

    public IVertexBuilder getBuffer(RenderType type) {
        return new TintingVertexBuilder(this._buffer.getBuffer(type), this._alpha, this._red, this._green, this._blue);
    }

    private static class TintingVertexBuilder
    extends VertexBuilderWrapper {
        private final int _alpha;
        private final int _red;
        private final int _green;
        private final int _blue;

        TintingVertexBuilder(IVertexBuilder originalBuilder, int alpha, int red, int green, int blue) {
            super(originalBuilder);
            this._alpha = alpha;
            this._red = red;
            this._green = green;
            this._blue = blue;
        }

        @Override
        public IVertexBuilder func_225586_a_(int red, int green, int blue, int alpha) {
            return this._builder.func_225586_a_(red * this._red / 255, green * this._green / 255, blue * this._blue / 255, alpha * this._alpha / 255);
        }
    }
}

