/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.zerono.mods.zerocore.lib.data.json.JSONHelper;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractModRecipeBuilder<Builder extends AbstractModRecipeBuilder<Builder>> {
    private final List<ICondition> _conditions;
    private final Advancement.Builder _advancementBuilder;
    private final ResourceLocation _serializerId;

    protected AbstractModRecipeBuilder(ResourceLocation serializerId) {
        this._serializerId = serializerId;
        this._advancementBuilder = Advancement.Builder.func_200278_a();
        this._conditions = Lists.newArrayList();
    }

    protected abstract IFinishedRecipe getFinishedRecipe(ResourceLocation var1);

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.hasCriteria()) {
            this._advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        }
        consumer.accept(this.getFinishedRecipe(id));
    }

    public Builder addCriterion(String name, ICriterionInstance criterionIn) {
        this._advancementBuilder.func_200275_a(name, criterionIn);
        return this.self();
    }

    public boolean hasCriteria() {
        return !this._advancementBuilder.func_200277_c().isEmpty();
    }

    public Builder addCondition(ICondition condition) {
        this._conditions.add(condition);
        return this.self();
    }

    private Builder self() {
        return (Builder)this;
    }

    protected abstract class AbstractFinishedRecipe
    implements IFinishedRecipe {
        private final ResourceLocation _id;

        public AbstractFinishedRecipe(ResourceLocation id) {
            this._id = id;
        }

        public JsonObject func_200441_a() {
            JsonObject json = new JsonObject();
            JSONHelper.jsonSetResourceLocation(json, "type", AbstractModRecipeBuilder.this._serializerId);
            if (!AbstractModRecipeBuilder.this._conditions.isEmpty()) {
                json.add("conditions", (JsonElement)AbstractModRecipeBuilder.this._conditions.stream().map(CraftingHelper::serialize).collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
            }
            this.func_218610_a(json);
            return json;
        }

        public ResourceLocation func_200442_b() {
            return this._id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)Objects.requireNonNull(ForgeRegistries.RECIPE_SERIALIZERS.getValue(AbstractModRecipeBuilder.this._serializerId), () -> "Unknown recipe serializer: " + AbstractModRecipeBuilder.this._serializerId);
        }

        @Nullable
        public JsonObject func_200440_c() {
            return AbstractModRecipeBuilder.this.hasCriteria() ? AbstractModRecipeBuilder.this._advancementBuilder.func_200273_b() : null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return new ResourceLocation(this._id.func_110624_b(), "recipes/" + this._id.func_110623_a());
        }
    }
}

