/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.energy;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.data.json.JSONHelper;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.IEnergySystemAware;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

@Deprecated
public final class EnergyStack
implements IEnergySystemAware {
    public static final EnergyStack EMPTY = new EnergyStack();
    private final EnergySystem _system;
    private double _amount;

    public EnergyStack(EnergySystem system) {
        this(system, 0.0);
    }

    public EnergyStack(EnergySystem system, double amount) {
        EnergyStack.isValidAmount(amount);
        this._system = system;
        this._amount = amount;
    }

    public EnergyStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new EnergyStack(this._system, this._amount);
    }

    public boolean isEmpty() {
        return EMPTY == this || Double.isNaN(this._amount);
    }

    public boolean isEnergySystemEqual(EnergyStack other) {
        return !other.isEmpty() && this.getEnergySystem() == other.getEnergySystem();
    }

    public static boolean areItemStacksEqual(EnergyStack stackA, EnergyStack stackB) {
        if (stackA.isEmpty() && stackB.isEmpty()) {
            return true;
        }
        return !stackA.isEmpty() && !stackB.isEmpty() && stackA.isStackEqual(stackB);
    }

    public double getMaxStackSize() {
        return Double.MAX_VALUE;
    }

    public double getAmount() {
        return this.isEmpty() ? 0.0 : this._amount;
    }

    public void setAmount(double amount) {
        EnergyStack.isValidAmount(amount);
        this._amount = amount;
    }

    public void grow(double amount) {
        this.setAmount(this._amount + amount);
    }

    public void shrink(double amount) {
        this.grow(-amount);
    }

    public CompoundNBT serializeTo(CompoundNBT nbt) {
        NBTHelper.nbtSetEnum(nbt, "sys", this._system);
        nbt.func_74780_a("amount", this._amount);
        return nbt;
    }

    public static EnergyStack from(CompoundNBT nbt) {
        if (nbt.func_74764_b("sys") && nbt.func_74764_b("amount")) {
            return new EnergyStack(NBTHelper.nbtGetEnum(nbt, "sys", EnergySystem.class), nbt.func_74769_h("amount"));
        }
        Log.LOGGER.info(Log.CORE, "Tried to read an EnergyStack from invalid NBT data");
        return EMPTY;
    }

    public void serializeTo(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this._system);
        buffer.writeDouble(this._amount);
    }

    public static EnergyStack from(PacketBuffer buffer) {
        try {
            return new EnergyStack((EnergySystem)buffer.func_179257_a(EnergySystem.class), buffer.readDouble());
        }
        catch (RuntimeException ex) {
            Log.LOGGER.info(Log.CORE, "Tried to read an EnergyStack from invalid packet data");
            return EMPTY;
        }
    }

    public JsonElement serializeTo() {
        JsonObject json = new JsonObject();
        JSONHelper.jsonSetEnum(json, "sys", this._system);
        JSONHelper.jsonSetDouble(json, "amount", this._amount);
        return json;
    }

    public static EnergyStack from(JsonElement element) {
        try {
            JsonObject json = element.getAsJsonObject();
            return new EnergyStack(JSONHelper.jsonGetEnum(json, "sys", EnergySystem.class), JSONHelper.jsonGetDouble(json, "amount"));
        }
        catch (RuntimeException ex) {
            Log.LOGGER.info(Log.CORE, "Tried to read an EnergyStack from invalid JSON data");
            return EMPTY;
        }
    }

    @Override
    public EnergySystem getEnergySystem() {
        return this._system;
    }

    public String toString() {
        return this._amount + " " + (Object)((Object)this._system);
    }

    private EnergyStack() {
        this._system = EnergySystem.REFERENCE;
        this._amount = Double.NaN;
    }

    private boolean isStackEqual(EnergyStack other) {
        return this._system == other._system && this._amount == other._amount;
    }

    private static void isValidAmount(double value) {
        if (value < 0.0 || Double.isNaN(value)) {
            throw new IllegalArgumentException("Illegal energy amount");
        }
    }
}

