/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.energy;

import com.google.common.base.Strings;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import net.minecraft.nbt.CompoundNBT;

public enum EnergySystem {
    ForgeEnergy("Forge Energy", "FE", 1.0),
    RedstoneFlux("Redstone Flux", "RF", 1.0),
    Tesla("Tesla", "T", 1.0),
    EnergyUnit("Energy Units", "EU", 0.25),
    MinecraftJoules("Minecraft Joules", "MJ", 0.1),
    Joules("Joules", "J", 2.5),
    GalacticraftJoules("Galacticraft Joules", "gJ", 1.6);

    public static final EnergySystem REFERENCE;
    private final String _name;
    private final String _unit;
    private final double _conversionRatio;
    private final WideAmount _conversionRatioWide;

    private EnergySystem(String name, String unit, double conversionRatio) {
        this._name = name;
        this._unit = unit;
        this._conversionRatio = conversionRatio;
        this._conversionRatioWide = WideAmount.asImmutable(conversionRatio);
    }

    public static EnergySystem read(CompoundNBT data, String key, EnergySystem defaultValue) {
        String value;
        if (data.func_74764_b(key) && !Strings.isNullOrEmpty((String)(value = data.func_74779_i(key)))) {
            return EnergySystem.valueOf(value);
        }
        return defaultValue;
    }

    public static void write(CompoundNBT data, String key, EnergySystem value) {
        data.func_74778_a(key, value.name());
    }

    public double convertTo(EnergySystem target, double amount) {
        return amount / this.getConversionRatio() * target.getConversionRatio();
    }

    public WideAmount convertTo(EnergySystem target, WideAmount amount) {
        return amount.divide(this._conversionRatioWide).multiply(target._conversionRatioWide);
    }

    public String getFullName() {
        return this._name;
    }

    public String getUnit() {
        return this._unit;
    }

    public double getConversionRatio() {
        return this._conversionRatio;
    }

    public String asHumanReadableNumber(double value) {
        return CodeHelper.formatAsHumanReadableNumber(value, this.getUnit());
    }

    public String toString() {
        return this.getUnit();
    }

    static {
        REFERENCE = ForgeEnergy;
    }
}

