/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.NonNullConsumer;

public class DoubleData
implements IContainerData {
    private final DoubleSupplier _getter;
    private final DoubleConsumer _setter;
    private double _lastValue;

    public DoubleData(DoubleSupplier getter, DoubleConsumer setter) {
        this._getter = getter;
        this._setter = setter;
        this._lastValue = 0.0;
    }

    public static DoubleData wrap(double[] array, int index) {
        return new DoubleData(() -> array[index], v -> {
            array[index] = v;
        });
    }

    @Override
    @Nullable
    public NonNullConsumer<PacketBuffer> getContainerDataWriter() {
        double current = this._getter.getAsDouble();
        if (this._lastValue != current) {
            this._lastValue = current;
            return buffer -> buffer.writeDouble(this._getter.getAsDouble());
        }
        return null;
    }

    @Override
    public void readContainerData(PacketBuffer dataSource) {
        this._setter.accept(dataSource.readDouble());
    }
}

