/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import it.zerono.mods.zerocore.lib.data.stack.IStackHolderAccess;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.fluid.FluidStackHolder;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackData
implements IContainerData {
    private final NonNullSupplier<FluidStack> _getter;
    private final NonNullConsumer<FluidStack> _setter;
    private FluidStack _lastValue;

    public FluidStackData(NonNullSupplier<FluidStack> getter, NonNullConsumer<FluidStack> setter) {
        this._getter = getter;
        this._setter = setter;
        this._lastValue = FluidStack.EMPTY;
    }

    public static FluidStackData wrap(NonNullList<FluidStack> list, int index) {
        return new FluidStackData((NonNullSupplier<FluidStack>)((NonNullSupplier)() -> (FluidStack)list.get(index)), (NonNullConsumer<FluidStack>)((NonNullConsumer)v -> {
            FluidStack cfr_ignored_0 = (FluidStack)list.set(index, v);
        }));
    }

    public static FluidStackData wrap(IStackHolderAccess<FluidStackHolder, FluidStack> holder, int index) {
        return new FluidStackData((NonNullSupplier<FluidStack>)((NonNullSupplier)() -> (FluidStack)holder.getStackAt(index)), (NonNullConsumer<FluidStack>)((NonNullConsumer)v -> holder.setStackAt(index, (FluidStack)v)));
    }

    @Override
    @Nullable
    public NonNullConsumer<PacketBuffer> getContainerDataWriter() {
        FluidStack current = (FluidStack)this._getter.get();
        if (this._lastValue.isEmpty() && current.isEmpty()) {
            return null;
        }
        boolean equalFluid = current.isFluidEqual(this._lastValue);
        if (!equalFluid || current.getAmount() != this._lastValue.getAmount()) {
            this._lastValue = current.copy();
            if (equalFluid) {
                return buffer -> {
                    buffer.writeByte(1);
                    buffer.func_150787_b(this._lastValue.getAmount());
                };
            }
            return buffer -> {
                buffer.writeByte(0);
                buffer.writeFluidStack(this._lastValue);
            };
        }
        return null;
    }

    @Override
    public void readContainerData(PacketBuffer dataSource) {
        switch (dataSource.readByte()) {
            case 0: {
                this._setter.accept((Object)dataSource.readFluidStack());
                break;
            }
            case 1: {
                this._setter.accept((Object)FluidHelper.stackFrom((FluidStack)this._getter.get(), dataSource.func_150792_a()));
            }
        }
    }
}

