/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.holder;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.IHeldRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.IRecipeHolder;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.nbt.CompoundNBT;

public class RecipeHolder<Recipe extends ModRecipe>
implements IRecipeHolder<Recipe>,
ISyncableEntity {
    private final Function<IRecipeHolder<Recipe>, IHeldRecipe<Recipe>> _factory;
    private final ToIntFunction<Recipe> _requiredTicks;
    private final BooleanConsumer _statusChanged;
    private final Predicate<Recipe> _canProcess;
    private final BooleanSupplier _ingredientsChanged;
    private final Runnable _beginRecipeProcessing;
    private final Runnable _recipeProcessed;
    private final IntConsumer _recipeTickProcessed;
    private final Consumer<Recipe> _recipeChanged;
    private IHeldRecipe<Recipe> _recipe;

    public static <Recipe extends ModRecipe> Builder<Recipe> builder(Function<IRecipeHolder<Recipe>, IHeldRecipe<Recipe>> factory, ToIntFunction<Recipe> requiredTicksSupplier) {
        return new Builder<Recipe>(factory, requiredTicksSupplier);
    }

    public boolean processRecipeIfPresent() {
        if (null != this._recipe) {
            return this._recipe.processRecipe();
        }
        return false;
    }

    @Override
    public <HeldRecipe extends IHeldRecipe<Recipe>> Optional<HeldRecipe> getHeldRecipe() {
        return Optional.ofNullable(this._recipe);
    }

    @Override
    public <HeldRecipe extends IHeldRecipe<Recipe>> Optional<HeldRecipe> createHeldRecipe() {
        this._recipe = this._factory.apply(this);
        this._recipeChanged.accept(null != this._recipe ? (Object)this._recipe.getRecipe() : null);
        return Optional.ofNullable(this._recipe);
    }

    @Override
    public int getRequiredTicks(Recipe recipe) {
        return this._requiredTicks.applyAsInt(recipe);
    }

    @Override
    public boolean canProcessRecipe(Recipe recipe) {
        return this._canProcess.test(recipe);
    }

    @Override
    public boolean hasRecipeIngredientsChanged() {
        return this._ingredientsChanged.getAsBoolean();
    }

    @Override
    public boolean shouldInvalidateRecipe() {
        return CodeHelper.shouldInvalidateResourceCache();
    }

    @Override
    public void invalidateRecipe() {
        this._recipe = null;
        this._recipeChanged.accept(null);
    }

    @Override
    public void onActiveStatusChanged(boolean active) {
        this._statusChanged.accept(active);
    }

    @Override
    public void onBeginRecipeProcessing() {
        this._beginRecipeProcessing.run();
    }

    @Override
    public void onRecipeTickProcessed(int tick) {
        this._recipeTickProcessed.accept(tick);
    }

    @Override
    public void onRecipeProcessed() {
        this._recipeProcessed.run();
    }

    @Override
    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        if (data.func_74764_b("recipetick")) {
            this.getHeldRecipe().ifPresent(r -> r.loadCurrentTick(data.func_74762_e("recipetick")));
        }
    }

    @Override
    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        data.func_74768_a("recipetick", this.getHeldRecipe().map(IHeldRecipe::getCurrentTick).orElse(0).intValue());
        return data;
    }

    private RecipeHolder(Builder<Recipe> builder) {
        this._factory = Objects.requireNonNull(((Builder)builder)._factory);
        this._requiredTicks = Objects.requireNonNull(((Builder)builder)._requiredTicks);
        this._canProcess = Objects.requireNonNull(((Builder)builder)._canProcess);
        this._ingredientsChanged = Objects.requireNonNull(((Builder)builder)._ingredientsChanged);
        this._statusChanged = Objects.requireNonNull(((Builder)builder)._statusChanged);
        this._beginRecipeProcessing = Objects.requireNonNull(((Builder)builder)._beginRecipeProcessing);
        this._recipeProcessed = Objects.requireNonNull(((Builder)builder)._recipeProcessed);
        this._recipeTickProcessed = Objects.requireNonNull(((Builder)builder)._recipeTickProcessed);
        this._recipeChanged = Objects.requireNonNull(((Builder)builder)._recipeChanged);
    }

    public static class Builder<Recipe extends ModRecipe> {
        private final Function<IRecipeHolder<Recipe>, IHeldRecipe<Recipe>> _factory;
        private final ToIntFunction<Recipe> _requiredTicks;
        private BooleanConsumer _statusChanged;
        private Predicate<Recipe> _canProcess;
        private BooleanSupplier _ingredientsChanged;
        private Runnable _beginRecipeProcessing;
        private Runnable _recipeProcessed;
        private IntConsumer _recipeTickProcessed;
        private Consumer<Recipe> _recipeChanged;

        public Builder(Function<IRecipeHolder<Recipe>, IHeldRecipe<Recipe>> factory, ToIntFunction<Recipe> requiredTicks) {
            this._factory = factory;
            this._requiredTicks = requiredTicks;
            this._statusChanged = CodeHelper.VOID_BOOL_CONSUMER;
            this._canProcess = r -> true;
            this._ingredientsChanged = CodeHelper.FALSE_SUPPLIER;
            this._beginRecipeProcessing = this._recipeProcessed = CodeHelper.VOID_RUNNABLE;
            this._recipeTickProcessed = CodeHelper.VOID_INT_CONSUMER;
            this._recipeChanged = r -> {};
        }

        public RecipeHolder<Recipe> build() {
            return new RecipeHolder(this);
        }

        public Builder<Recipe> onCanProcess(Predicate<Recipe> supplier) {
            this._canProcess = Objects.requireNonNull(supplier);
            return this;
        }

        public Builder<Recipe> onHasIngredientsChanged(BooleanSupplier supplier) {
            this._ingredientsChanged = Objects.requireNonNull(supplier);
            return this;
        }

        public Builder<Recipe> onActiveStatusChanged(BooleanConsumer consumer) {
            this._statusChanged = Objects.requireNonNull(consumer);
            return this;
        }

        public Builder<Recipe> onBeginRecipeProcessing(Runnable runnable) {
            this._beginRecipeProcessing = Objects.requireNonNull(runnable);
            return this;
        }

        public Builder<Recipe> onRecipeProcessed(Runnable runnable) {
            this._recipeProcessed = Objects.requireNonNull(runnable);
            return this;
        }

        public Builder<Recipe> onRecipeTickProcessed(IntConsumer consumer) {
            this._recipeTickProcessed = Objects.requireNonNull(consumer);
            return this;
        }

        public Builder<Recipe> onRecipeChanged(Consumer<Recipe> consumer) {
            this._recipeChanged = Objects.requireNonNull(consumer);
            return this;
        }
    }
}

