/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.world.ChunkCache;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public final class WorldHelper {
    public static final int DIMENSION_ID_OVERWORLD = 0;
    public static final int DIMENSION_ID_NETHER = -1;
    public static final int DIMENSION_ID_THEEND = 1;

    public static Optional<World> getClientWorld() {
        return ZeroCore.getProxy().getClientWorld();
    }

    public static Optional<ServerWorld> getServerWorld(RegistryKey<World> worldKey) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return null != server ? Optional.ofNullable(server.func_71218_a(worldKey)) : Optional.empty();
    }

    public static Stream<BlockPos> getNeighboringPositions(BlockPos origin) {
        return Stream.of(Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST).map(arg_0 -> ((BlockPos)origin).func_177972_a(arg_0));
    }

    public static BlockPos[] getNeighboringPositionsList(BlockPos origin, BlockPos[] storage) {
        for (int i = 0; i < CodeHelper.DIRECTIONS.length; ++i) {
            storage[i] = origin.func_177972_a(CodeHelper.DIRECTIONS[i]);
        }
        return storage;
    }

    public static Optional<BlockState> getBlockState(World world, BlockPos position) {
        return world.func_195588_v(position) ? Optional.of(world.func_180495_p(position)) : Optional.empty();
    }

    public static Stream<BlockState> getBlockStatesFrom(World world, Stream<BlockPos> positions) {
        return WorldHelper.getFromWorld(world, positions, WorldHelper::getBlockState);
    }

    public static Stream<Block> getBlocksFrom(World world, Stream<BlockPos> positions) {
        return WorldHelper.getBlockStatesFrom(world, positions).map(AbstractBlock.AbstractBlockState::func_177230_c);
    }

    public static void notifyBlockUpdate(World world, BlockPos position) {
        WorldHelper.notifyBlockUpdate(world, position, null, null);
    }

    public static void notifyBlockUpdate(World world, BlockPos position, @Nullable BlockState oldState, @Nullable BlockState newState) {
        if (null == oldState) {
            oldState = world.func_180495_p(position);
        }
        if (null == newState) {
            newState = oldState;
        }
        world.func_184138_a(position, oldState, newState, 3);
    }

    public static void markBlockRangeForRenderUpdate(BlockPos min, BlockPos max) {
        ZeroCore.getProxy().markBlockRangeForRenderUpdate(min, max);
    }

    public static void notifyNeighborsOfStateChange(World world, BlockPos pos, Block blockType) {
        world.func_195593_d(pos, blockType);
    }

    @Nullable
    public static TileEntity getLoadedTile(IWorldReader world, BlockPos position) {
        return World.func_175701_a((BlockPos)position) ? WorldHelper.getLoadedTile((Chunk)world.func_217353_a(position.func_177958_n() >> 4, position.func_177952_p() >> 4, ChunkStatus.field_222617_m, false), position) : null;
    }

    @Nullable
    public static TileEntity getLoadedTile(ChunkCache chunkCache, BlockPos position) {
        return World.func_175701_a((BlockPos)position) ? WorldHelper.getLoadedTile(chunkCache.get(position), position) : null;
    }

    @Nullable
    private static TileEntity getLoadedTile(@Nullable Chunk chunk, BlockPos position) {
        return null != chunk ? chunk.func_177424_a(position, Chunk.CreateEntityType.CHECK) : null;
    }

    public static Optional<TileEntity> getTile(World world, BlockPos position) {
        return world.func_175723_af().func_177746_a(position) ? Optional.ofNullable(WorldHelper.getLoadedTile((IWorldReader)world, position)) : Optional.empty();
    }

    @Deprecated
    public static Optional<TileEntity> getTile(IBlockReader world, BlockPos position) {
        if (world instanceof IWorldReader) {
            return Optional.ofNullable(WorldHelper.getLoadedTile((IWorldReader)world, position));
        }
        return Optional.ofNullable(world.func_175625_s(position));
    }

    public static Optional<TileEntity> getTile(World world, BlockPos origin, Direction direction) {
        return WorldHelper.getTile(world, origin.func_177972_a(direction));
    }

    public static Optional<TileEntity> getTile(TileEntity origin, Direction direction) {
        World world = origin.func_145831_w();
        return null != world ? WorldHelper.getTile(world, origin.func_174877_v().func_177972_a(direction)) : Optional.empty();
    }

    public static Stream<TileEntity> getTilesFrom(World world, Stream<BlockPos> positions) {
        return WorldHelper.getFromWorld(world, positions, WorldHelper::getTile);
    }

    public static <Controller extends IMultiblockController<Controller>> Optional<IMultiblockPart<Controller>> getMultiblockPartFrom(World world, BlockPos position) {
        return WorldHelper.getTile(world, position).filter(te -> te instanceof IMultiblockPart).map(te -> (IMultiblockPart)te);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends TileEntity> Optional<T> getClientTile(BlockPos position) {
        return WorldHelper.getClientWorld().map(w -> WorldHelper.getLoadedTile((IWorldReader)w, position));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends TileEntity> Optional<T> getClientTile(BlockPos position, Direction direction) {
        return WorldHelper.getClientTile(position.func_177972_a(direction));
    }

    public static int getChunkXFromBlock(int blockX) {
        return blockX >> 4;
    }

    public static int getChunkXFromBlock(BlockPos position) {
        return position.func_177958_n() >> 4;
    }

    public static int getChunkZFromBlock(int blockZ) {
        return blockZ >> 4;
    }

    public static int getChunkZFromBlock(BlockPos position) {
        return position.func_177952_p() >> 4;
    }

    public static long getChunkXZHashFromBlock(int blockX, int blockZ) {
        return ChunkPos.func_77272_a((int)WorldHelper.getChunkXFromBlock(blockX), (int)WorldHelper.getChunkZFromBlock(blockZ));
    }

    public static long getChunkXZHashFromBlock(BlockPos position) {
        return ChunkPos.func_77272_a((int)WorldHelper.getChunkXFromBlock(position), (int)WorldHelper.getChunkZFromBlock(position));
    }

    public static boolean chunkExists(World world, BlockPos position) {
        return world.func_217354_b(WorldHelper.getChunkXFromBlock(position), WorldHelper.getChunkZFromBlock(position));
    }

    public static boolean isEntityInRange(Entity entity, double x, double y, double z, double range) {
        return entity.func_70092_e(x + 0.5, y + 0.5, z + 0.5) < range * range;
    }

    public static boolean isEntityInRange(Entity entity, BlockPos position, double range) {
        return entity.func_70092_e((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5) < range * range;
    }

    public static <T extends IParticleData> void spawnVanillaParticles(World world, T particle, int minCount, int maxCount, int x, int y, int z, int offsetX, int offsetY, int offsetZ) {
        Random rand = world.field_73012_v;
        int howMany = MathHelper.func_76136_a((Random)rand, (int)minCount, (int)maxCount);
        double px1 = (double)(x - offsetX) + 0.5;
        double px2 = (double)(x + offsetX) + 0.5;
        double py1 = y;
        double py2 = y + offsetY;
        double pz1 = (double)(z - offsetZ) + 0.5;
        double pz2 = (double)(z + offsetZ) + 0.5;
        if (world instanceof ServerWorld) {
            ServerWorld ws = (ServerWorld)world;
            double motionX = rand.nextGaussian() * 0.02;
            double motionY = rand.nextGaussian() * 0.02;
            double motionZ = rand.nextGaussian() * 0.02;
            double pX = MathHelper.func_82716_a((Random)rand, (double)px1, (double)px2);
            double pY = MathHelper.func_82716_a((Random)rand, (double)py1, (double)py2);
            double pZ = MathHelper.func_82716_a((Random)rand, (double)pz1, (double)pz2);
            ws.func_195598_a(particle, pX, pY, pZ, howMany, motionX, motionY, motionZ, rand.nextGaussian() * 0.02);
        } else {
            for (int i = 0; i < howMany; ++i) {
                double motionX = rand.nextGaussian() * 0.02;
                double motionY = rand.nextGaussian() * 0.02;
                double motionZ = rand.nextGaussian() * 0.02;
                double pX = MathHelper.func_82716_a((Random)rand, (double)px1, (double)px2);
                double pY = MathHelper.func_82716_a((Random)rand, (double)py1, (double)py2);
                double pZ = MathHelper.func_82716_a((Random)rand, (double)pz1, (double)pz2);
                world.func_195594_a(particle, pX, pY, pZ, motionX, motionY, motionZ);
            }
        }
    }

    public static void spawnItemStack(ItemStack stack, World world, double x, double y, double z, boolean withMomentum) {
        float z2;
        float y2;
        float x2;
        if (withMomentum) {
            x2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            y2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            z2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        } else {
            x2 = 0.5f;
            y2 = 0.0f;
            z2 = 0.5f;
        }
        ItemEntity entity = new ItemEntity(world, x + (double)x2, y + (double)y2, z + (double)z2, ItemHelper.stackFrom(stack));
        if (withMomentum) {
            entity.func_213293_j(world.field_73012_v.nextGaussian() * (double)0.05f, world.field_73012_v.nextGaussian() * (double)0.05f + (double)0.2f, world.field_73012_v.nextGaussian() * (double)0.05f);
        } else {
            entity.func_213293_j(0.0, (double)-0.05f, 0.0);
        }
        world.func_217376_c((Entity)entity);
    }

    public static boolean isFluidStateTagged(IBlockReader access, BlockPos position, ITag.INamedTag<Fluid> tag) {
        return access.func_204610_c(position).func_206884_a(tag);
    }

    public static boolean isFluidStateTagged(BlockState blockState, ITag.INamedTag<Fluid> tag) {
        return blockState.func_204520_s().func_206884_a(tag);
    }

    private static <T> Stream<T> getFromWorld(World world, Stream<BlockPos> positions, BiFunction<World, BlockPos, Optional<T>> getter) {
        return positions.map(position -> (Optional)getter.apply(world, (BlockPos)position)).filter(Optional::isPresent).map(Optional::get);
    }

    private WorldHelper() {
    }
}

