/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.utils.FastEither;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public class GeneratorFuel
extends IESerializableRecipe {
    public static IRecipeType<GeneratorFuel> TYPE;
    public static RegistryObject<IERecipeSerializer<GeneratorFuel>> SERIALIZER;
    public static Collection<GeneratorFuel> ALL_FUELS;
    final FastEither<ITag<Fluid>, List<Fluid>> fluids;
    private final int burnTime;

    public GeneratorFuel(ResourceLocation id, ITag<Fluid> fluids, int burnTime) {
        super(ItemStack.field_190927_a, TYPE, id);
        this.fluids = FastEither.left(fluids);
        this.burnTime = burnTime;
    }

    public GeneratorFuel(ResourceLocation id, List<Fluid> fluids, int burnTime) {
        super(ItemStack.field_190927_a, TYPE, id);
        this.fluids = FastEither.right(fluids);
        this.burnTime = burnTime;
    }

    public List<Fluid> getFluids() {
        return this.fluids.map(ITag::func_230236_b_, Function.identity());
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    @Override
    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean matches(Fluid in) {
        if (this.fluids.isLeft()) {
            return in.func_207185_a(this.fluids.leftNonnull());
        }
        return this.fluids.rightNonnull().contains(in);
    }

    public static GeneratorFuel getRecipeFor(Fluid in, @Nullable GeneratorFuel hint) {
        if (hint != null && hint.matches(in)) {
            return hint;
        }
        for (GeneratorFuel fuel : ALL_FUELS) {
            if (!fuel.matches(in)) continue;
            return fuel;
        }
        return null;
    }

    static {
        ALL_FUELS = new ArrayList<GeneratorFuel>();
    }
}

