/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.entity;

import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseMinecart;
import blusunrize.immersiveengineering.mixin.accessors.client.MinecartRendererAccess;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.MinecartModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;

public class ShaderMinecartRenderer<T extends AbstractMinecartEntity>
extends MinecartRenderer<T> {
    public static Int2ObjectMap<ItemStack> shadedCarts = new Int2ObjectOpenHashMap();
    public static boolean rendersReplaced = false;
    private final MinecartRenderer<T> baseRenderer;

    public ShaderMinecartRenderer(MinecartRenderer<T> base, EntityRendererManager manager) {
        super(manager);
        this.baseRenderer = base;
    }

    public void func_225623_a_(T entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        ItemStack shader;
        ShaderCase sCase = null;
        if (shadedCarts.containsKey(entity.func_145782_y()) && (shader = (ItemStack)shadedCarts.get(entity.func_145782_y())) != null && !shader.func_190926_b() && shader.func_77973_b() instanceof IShaderItem) {
            sCase = ((IShaderItem)shader.func_77973_b()).getShaderCase(shader, null, new ResourceLocation("immersiveengineering", "minecart"));
        }
        this.baseRenderer.func_225623_a_(entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (sCase != null) {
            matrixStackIn.func_227860_a_();
            this.applyTransforms(matrixStackIn, entity, partialTicks, entityYaw);
            MinecartModel<?> model = this.getModel();
            ArrayList boxList = Lists.newArrayList((Iterable)model.func_225601_a_());
            ((ModelRenderer)boxList.get((int)5)).field_78797_d = 4.1f;
            for (int part = 0; part < boxList.size() - 1; ++part) {
                if (boxList.get(part) == null) continue;
                float scale = 1.0f;
                ShaderLayer[] layers = sCase.getLayers();
                for (int pass = 0; pass < layers.length; ++pass) {
                    if (!sCase.shouldRenderGroupForPass("" + part, pass)) continue;
                    Vector4f col = sCase.getRenderColor("" + part, pass, new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
                    matrixStackIn.func_227860_a_();
                    matrixStackIn.func_227862_a_(scale, scale, scale);
                    RenderType type = sCase.getLayers()[pass].getRenderType(RenderType.func_228644_e_((ResourceLocation)sCase.getTextureReplacement(Integer.toString(part), pass)));
                    ModelRenderer subModel = (ModelRenderer)boxList.get(part);
                    boolean oldMirrored = subModel.field_78809_i;
                    subModel.field_78809_i = ((ShaderCaseMinecart)sCase).mirrorSideForPass[pass];
                    subModel.func_228309_a_(matrixStackIn, bufferIn.getBuffer(type), packedLightIn, OverlayTexture.field_229196_a_, col.func_195910_a(), col.func_195913_b(), col.func_195914_c(), col.func_195915_d());
                    subModel.field_78809_i = oldMirrored;
                    matrixStackIn.func_227865_b_();
                }
            }
            matrixStackIn.func_227865_b_();
        }
    }

    private MinecartModel<?> getModel() {
        EntityModel<?> model = ((MinecartRendererAccess)this.baseRenderer).getModel();
        if (model instanceof MinecartModel) {
            return (MinecartModel)model;
        }
        return new MinecartModel();
    }

    private void applyTransforms(MatrixStack matrixStackIn, T entityIn, float partialTicks, float entityYaw) {
        long i = (long)entityIn.func_145782_y() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        matrixStackIn.func_227861_a_((double)f, (double)f1, (double)f2);
        double d0 = MathHelper.func_219803_d((double)partialTicks, (double)((AbstractMinecartEntity)entityIn).field_70142_S, (double)entityIn.func_226277_ct_());
        double d1 = MathHelper.func_219803_d((double)partialTicks, (double)((AbstractMinecartEntity)entityIn).field_70137_T, (double)entityIn.func_226278_cu_());
        double d2 = MathHelper.func_219803_d((double)partialTicks, (double)((AbstractMinecartEntity)entityIn).field_70136_U, (double)entityIn.func_226281_cx_());
        Vector3d vec3d = entityIn.func_70489_a(d0, d1, d2);
        float f3 = MathHelper.func_219799_g((float)partialTicks, (float)((AbstractMinecartEntity)entityIn).field_70127_C, (float)((AbstractMinecartEntity)entityIn).field_70125_A);
        if (vec3d != null) {
            Vector3d vec3d1 = entityIn.func_70495_a(d0, d1, d2, (double)0.3f);
            Vector3d vec3d2 = entityIn.func_70495_a(d0, d1, d2, (double)-0.3f);
            if (vec3d1 == null) {
                vec3d1 = vec3d;
            }
            if (vec3d2 == null) {
                vec3d2 = vec3d;
            }
            matrixStackIn.func_227861_a_(vec3d.field_72450_a - d0, (vec3d1.field_72448_b + vec3d2.field_72448_b) / 2.0 - d1, vec3d.field_72449_c - d2);
            Vector3d vec3d3 = vec3d2.func_72441_c(-vec3d1.field_72450_a, -vec3d1.field_72448_b, -vec3d1.field_72449_c);
            if (vec3d3.func_72433_c() != 0.0) {
                vec3d3 = vec3d3.func_72432_b();
                entityYaw = (float)(Math.atan2(vec3d3.field_72449_c, vec3d3.field_72450_a) * 180.0 / Math.PI);
                f3 = (float)(Math.atan(vec3d3.field_72448_b) * 73.0);
            }
        }
        matrixStackIn.func_227861_a_(0.0, 0.375, 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entityYaw));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-f3));
        float f5 = (float)entityIn.func_70496_j() - partialTicks;
        float f6 = entityIn.func_70491_i() - partialTicks;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_76126_a((float)f5) * f5 * f6 / 10.0f * (float)entityIn.func_70493_k()));
        }
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
    }

    public static <T extends Entity> void overrideModelIfMinecart(EntityType<T> type) {
        EntityRendererManager rendererManager = Minecraft.func_71410_x().func_175598_ae();
        EntityRenderer render = (EntityRenderer)rendererManager.field_78729_o.get(type);
        if (render instanceof MinecartRenderer) {
            rendererManager.func_229087_a_(type, new ShaderMinecartRenderer<T>((MinecartRenderer)render, rendererManager));
        }
    }
}

