/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class CapacitorTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.ITileDrop {
    public EnumMap<Direction, IEEnums.IOSideConfig> sideConfig = new EnumMap(Direction.class);
    private final IEServerConfig.Machines.CapacitorConfig configValues;
    FluxStorage energyStorage;
    public int comparatorOutput = 0;
    private EnergyHelper.IEForgeEnergyWrapper[] wrappers = EnergyHelper.IEForgeEnergyWrapper.getDefaultWrapperArray(this);

    public CapacitorTileEntity(IEServerConfig.Machines.CapacitorConfig configValues) {
        super(configValues.tileType.get());
        this.configValues = configValues;
        for (Direction f : DirectionUtils.VALUES) {
            if (f == Direction.UP) {
                this.sideConfig.put(f, IEEnums.IOSideConfig.INPUT);
                continue;
            }
            this.sideConfig.put(f, IEEnums.IOSideConfig.NONE);
        }
        this.energyStorage = new FluxStorage(this.getMaxStorage(), this.getMaxInput(), this.getMaxOutput());
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            for (Direction f : DirectionUtils.VALUES) {
                this.transferEnergy(f);
            }
            if (this.field_145850_b.func_82737_E() % 32L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x1F) && (i = this.scaleStoredEnergyTo(15)) != this.comparatorOutput) {
                this.comparatorOutput = i;
                this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_195044_w().func_177230_c());
            }
        }
    }

    public int scaleStoredEnergyTo(int scale) {
        return (int)((float)scale * ((float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored()));
    }

    protected void transferEnergy(Direction side) {
        if (this.sideConfig.get(side) != IEEnums.IOSideConfig.OUTPUT) {
            return;
        }
        BlockPos outPos = this.func_174877_v().func_177972_a(side);
        TileEntity tileEntity = Utils.getExistingTileEntity(this.field_145850_b, outPos);
        int out = Math.min(this.getMaxOutput(), this.energyStorage.getEnergyStored());
        this.energyStorage.modifyEnergyStored(-EnergyHelper.insertFlux((ICapabilityProvider)tileEntity, side.func_176734_d(), out, false));
    }

    @Override
    public IEEnums.IOSideConfig getSideConfig(Direction side) {
        return this.sideConfig.get(side);
    }

    @Override
    public boolean toggleSide(Direction side, PlayerEntity player) {
        this.sideConfig.put(side, IEEnums.IOSideConfig.next(this.sideConfig.get(side)));
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 0, 0);
        return true;
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    public final int getMaxStorage() {
        return this.configValues.storage.getAsInt();
    }

    public final int getMaxInput() {
        return this.configValues.input.getAsInt();
    }

    public final int getMaxOutput() {
        return this.configValues.output.getAsInt();
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        for (Direction f : DirectionUtils.VALUES) {
            nbt.func_74768_a("sideConfig_" + f.ordinal(), this.sideConfig.get(f).ordinal());
        }
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        for (Direction f : DirectionUtils.VALUES) {
            this.sideConfig.put(f, IEEnums.IOSideConfig.values()[nbt.func_74762_e("sideConfig_" + f.ordinal())]);
        }
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(@Nullable Direction facing) {
        if (facing == null) {
            return IEEnums.IOSideConfig.NONE;
        }
        return this.sideConfig.get(facing);
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        if (facing == null) {
            return null;
        }
        return this.wrappers[facing.ordinal()];
    }

    @Override
    public ITextComponent[] getOverlayText(PlayerEntity player, RayTraceResult mop, boolean hammer) {
        if (hammer && ((Boolean)IEClientConfig.showTextOverlay.get()).booleanValue() && mop instanceof BlockRayTraceResult) {
            BlockRayTraceResult bmop = (BlockRayTraceResult)mop;
            IEEnums.IOSideConfig here = this.sideConfig.get(bmop.func_216354_b());
            IEEnums.IOSideConfig opposite = this.sideConfig.get(bmop.func_216354_b().func_176734_d());
            return TextUtils.sideConfigWithOpposite("desc.immersiveengineering.info.blockSide.connectEnergy.", here, opposite);
        }
        return null;
    }

    @Override
    public boolean useNixieFont(PlayerEntity player, RayTraceResult mop) {
        return false;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.comparatorOutput;
    }

    @Override
    public List<ItemStack> getTileDrops(LootContext context) {
        ItemStack stack = new ItemStack((IItemProvider)this.func_195044_w().func_177230_c(), 1);
        this.writeCustomNBT(stack.func_196082_o(), false);
        return ImmutableList.of((Object)stack);
    }

    @Override
    public void readOnPlacement(@Nullable LivingEntity placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readCustomNBT(stack.func_196082_o(), false);
        }
    }
}

