/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.ItemHandlerHelper;

public class ArcRecyclingRecipe
extends ArcFurnaceRecipe {
    private Map<ItemStack, Double> outputs;
    private final Lazy<NonNullList<ItemStack>> defaultOutputs = Lazy.of(() -> {
        NonNullList ret = NonNullList.func_191196_a();
        for (Map.Entry<ItemStack, Double> e : this.outputs.entrySet()) {
            double scaledOut = e.getValue();
            this.addOutputToList(scaledOut, (NonNullList<ItemStack>)ret, e);
        }
        return ret;
    });

    public ArcRecyclingRecipe(ResourceLocation id, Map<ItemStack, Double> outputs, IngredientWithSize input, int time, int energyPerTick) {
        super(id, (NonNullList<ItemStack>)outputs.keySet().stream().collect(NonNullList::func_191196_a, AbstractList::add, AbstractCollection::addAll), input, ItemStack.field_190927_a, time, energyPerTick, new IngredientWithSize[0]);
        this.outputs = outputs;
        this.setSpecialRecipeType("Recycling");
    }

    @Override
    public NonNullList<ItemStack> getOutputs(ItemStack input, NonNullList<ItemStack> additives) {
        if (this.outputs == null) {
            return NonNullList.func_191196_a();
        }
        float mod = !input.func_77984_f() ? 1.0f : (float)(input.func_77958_k() - input.func_77952_i()) / (float)input.func_77958_k();
        NonNullList outs = NonNullList.func_191196_a();
        for (Map.Entry<ItemStack, Double> e : this.outputs.entrySet()) {
            double scaledOut = (double)mod * e.getValue();
            this.addOutputToList(scaledOut, (NonNullList<ItemStack>)outs, e);
        }
        return outs;
    }

    @Override
    public NonNullList<ItemStack> getItemOutputs() {
        return (NonNullList)this.defaultOutputs.get();
    }

    private void addOutputToList(double scaledOut, NonNullList<ItemStack> outs, Map.Entry<ItemStack, Double> e) {
        String[] type;
        int nuggetOut;
        if (scaledOut >= 1.0) {
            outs.add((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)e.getKey(), (int)((int)scaledOut)));
        }
        if ((nuggetOut = (int)((scaledOut - (double)((int)scaledOut)) * 9.0)) > 0 && (type = TagUtils.getMatchingPrefixAndRemaining(e.getKey(), "ingots")) != null) {
            ItemStack nuggets = IEApi.getPreferredTagStack(IETags.getNugget(type[1]));
            outs.add((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)nuggets, (int)nuggetOut));
        }
    }

    @Override
    public boolean matches(ItemStack input, NonNullList<ItemStack> additives) {
        return !input.func_190926_b() && this.input.test(input);
    }

    public Map<ItemStack, Double> getOutputs() {
        return this.outputs;
    }
}

