/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.block;

import java.util.List;
import javax.annotation.Nullable;
import lehjr.numina.container.ChargingBaseContainer;
import lehjr.numina.entity.NuminaArmorStandEntity;
import lehjr.numina.tileentity.ChargingBaseTileEntity;
import lehjr.numina.util.client.sound.SoundDictionary;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ChargingBaseBlock
extends Block
implements IWaterLoggable {
    private static final ITextComponent title = new TranslationTextComponent("container.crafting", new Object[0]);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape BASE_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public ChargingBaseBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(0.5f, 4.0f).func_200947_a(SoundType.field_185858_k).harvestLevel(0).func_235861_h_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader reader, List<ITextComponent> list, ITooltipFlag flags) {
        list.add((ITextComponent)new TranslationTextComponent("message.charging_base", new Object[]{Integer.toString(1000)}));
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) != false ? super.getLightValue(state, world, pos) : 0;
    }

    public ActionResultType func_225533_a_(BlockState state, final World worldIn, final BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof ChargingBaseTileEntity) {
                player.func_184185_a(SoundDictionary.SOUND_EVENT_GUI_SELECT, 1.0f, 1.0f);
                INamedContainerProvider containerProvider = new INamedContainerProvider(){

                    public ITextComponent func_145748_c_() {
                        return new TranslationTextComponent("screen.numina.charging_base");
                    }

                    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                        return new ChargingBaseContainer(i, worldIn, pos, playerInventory, playerEntity);
                    }
                };
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)containerProvider, (BlockPos)tileEntity.func_174877_v());
            } else {
                throw new IllegalStateException("container provider is missing!");
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.field_72995_K && entityIn instanceof NuminaArmorStandEntity && pos.func_177956_o() > (int)entityIn.func_213303_ch().field_72448_b) {
            entityIn.func_70634_a((double)pos.func_177958_n() + 0.5, entityIn.func_213303_ch().field_72448_b + 1.0, (double)pos.func_177952_p() + 0.5);
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    public int getHarvestLevel(BlockState state) {
        return 1;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, BlockStateProperties.field_208194_u});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BASE_SHAPE;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ChargingBaseTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8));
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, BlockState state) {
        return Fluids.field_204541_a;
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return true;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

