/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.model.item.armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.util.capabilities.render.IArmorModelSpecNBT;
import lehjr.numina.util.capabilities.render.ModelSpecNBTCapability;
import lehjr.numina.util.capabilities.render.modelspec.EnumSpecType;
import lehjr.numina.util.math.Colour;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class NuminaArmorLayer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends BipedArmorLayer<T, M, A> {
    public NuminaArmorLayer(IEntityRenderer<T, M> entityRenderer, A modelLeggings, A modelArmor) {
        super(entityRenderer, modelLeggings, modelArmor);
    }

    public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.func_241739_a_(matrixStackIn, bufferIn, entityIn, EquipmentSlotType.CHEST, packedLightIn, this.getModelFromSlot(EquipmentSlotType.CHEST));
        this.func_241739_a_(matrixStackIn, bufferIn, entityIn, EquipmentSlotType.LEGS, packedLightIn, this.getModelFromSlot(EquipmentSlotType.LEGS));
        this.func_241739_a_(matrixStackIn, bufferIn, entityIn, EquipmentSlotType.FEET, packedLightIn, this.getModelFromSlot(EquipmentSlotType.FEET));
        this.func_241739_a_(matrixStackIn, bufferIn, entityIn, EquipmentSlotType.HEAD, packedLightIn, this.getModelFromSlot(EquipmentSlotType.HEAD));
    }

    private A getModelFromSlot(EquipmentSlotType slot) {
        return (A)(this.isLegSlot(slot) ? this.field_177189_c : this.field_177186_d);
    }

    private boolean isLegSlot(EquipmentSlotType slotIn) {
        return slotIn == EquipmentSlotType.LEGS;
    }

    public void func_241739_a_(MatrixStack matrixIn, IRenderTypeBuffer bufferIn, T entityIn, EquipmentSlotType slotIn, int packedLightIn, A model) {
        ArmorItem armoritem;
        ItemStack itemstack = entityIn.func_184582_a(slotIn);
        boolean hasEffect = itemstack.func_77962_s();
        if (itemstack.func_77973_b() instanceof ArmorItem && (armoritem = (ArmorItem)itemstack.func_77973_b()).func_185083_B_() == slotIn) {
            if (itemstack.getCapability(ModelSpecNBTCapability.RENDER).isPresent()) {
                itemstack.getCapability(ModelSpecNBTCapability.RENDER).ifPresent(spec -> {
                    BipedModel actualModel = this.getArmorModelHook(entityIn, itemstack, slotIn, model);
                    ((BipedModel)this.func_215332_c()).func_217148_a(actualModel);
                    this.func_188359_a(actualModel, slotIn);
                    if (spec.getSpecType() == EnumSpecType.ARMOR_SKIN) {
                        Colour colour = spec.getColorFromItemStack();
                        this.renderArmor(matrixIn, bufferIn, packedLightIn, hasEffect, actualModel, colour.r, colour.g, colour.b, this.getArmorResource((Entity)entityIn, itemstack, slotIn, null));
                        this.renderArmor(matrixIn, bufferIn, packedLightIn, hasEffect, actualModel, colour.r, colour.g, colour.b, this.getArmorResource((Entity)entityIn, itemstack, slotIn, "overlay"));
                    } else {
                        this.renderArmor(matrixIn, bufferIn, packedLightIn, hasEffect, actualModel, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)entityIn, itemstack, slotIn, null));
                    }
                });
            } else {
                super.func_241739_a_(matrixIn, bufferIn, entityIn, slotIn, packedLightIn, model);
            }
        }
    }

    private void renderArmor(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, boolean glintIn, A modelIn, float red, float green, float blue, ResourceLocation armorResource) {
        RenderType renderType = armorResource == AtlasTexture.field_110575_b ? Atlases.func_228785_j_() : RenderType.func_228640_c_((ResourceLocation)armorResource);
        IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)renderType, (boolean)false, (boolean)glintIn);
        modelIn.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
    }

    public ResourceLocation getArmorResource(Entity entity, @Nonnull ItemStack stack, EquipmentSlotType slot, @Nullable String type) {
        return stack.getCapability(ModelSpecNBTCapability.RENDER).map(spec -> {
            if (spec.getSpecType() == EnumSpecType.ARMOR_SKIN && spec instanceof IArmorModelSpecNBT) {
                return new ResourceLocation(((IArmorModelSpecNBT)spec).getArmorTexture());
            }
            return AtlasTexture.field_110575_b;
        }).orElse(super.getArmorResource(entity, stack, slot, type));
    }

    protected A getArmorModelHook(T entity, ItemStack itemStack, EquipmentSlotType slot, A model) {
        return (A)super.getArmorModelHook(entity, itemStack, slot, model);
    }
}

