/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.basemod.NuminaObjects;
import lehjr.numina.config.NuminaSettings;
import lehjr.numina.util.capabilities.energy.ForgeEnergyModuleWrapper;
import lehjr.numina.util.capabilities.energy.IEnergyWrapper;
import lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.util.capabilities.module.powermodule.PowerModule;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.string.AdditionalInfo;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class Battery
extends Item {
    protected int maxEnergy;
    protected int maxTransfer;
    protected final int tier;

    public Battery(int maxEnergy, int maxTransfer, int tier) {
        super(new Item.Properties().func_200917_a(1).func_200916_a((ItemGroup)NuminaObjects.creativeTab).func_200915_b(-1).setNoRepair());
        this.maxEnergy = maxEnergy;
        this.maxTransfer = maxTransfer;
        this.tier = tier;
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<ITextComponent> tooltips, ITooltipFlag flagIn) {
        if (worldIn != null) {
            super.func_77624_a(itemStack, worldIn, tooltips, flagIn);
            AdditionalInfo.appendHoverText(itemStack, worldIn, tooltips, flagIn);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (this.func_194125_a(group)) {
            ItemStack out = new ItemStack((IItemProvider)this);
            CapProvider provider = new CapProvider(out);
            int maxEnergy = (int)provider.moduleCap.applyPropertyModifiers("maxEnergy");
            provider.energyStorage.receiveEnergy(maxEnergy, false);
            items.add((Object)out);
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY).map(energyCap -> energyCap.getMaxEnergyStored() > 0).orElse(false);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY).map(energyCap -> 1.0 - (double)energyCap.getEnergyStored() / (double)energyCap.getMaxEnergyStored()).orElse(1.0);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IPowerModule moduleCap;
        IEnergyWrapper energyStorage;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.moduleCap = new PowerModule(module, ModuleCategory.ENERGY_STORAGE, ModuleTarget.ALLITEMS, NuminaSettings::getModuleConfig){
                {
                    super(module, category, target, moduleConfigGetterIn);
                    this.addBaseProperty("maxEnergy", Battery.this.maxEnergy, "FE");
                    this.addBaseProperty("maxTransfer", Battery.this.maxTransfer, "FE");
                }

                @Override
                public int getTier() {
                    return Battery.this.tier;
                }

                @Override
                public String getModuleGroup() {
                    return "Battery";
                }
            };
            this.energyStorage = new ForgeEnergyModuleWrapper(module, (int)this.moduleCap.applyPropertyModifiers("maxEnergy"), (int)this.moduleCap.applyPropertyModifiers("maxTransfer"));
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityEnergy.ENERGY) {
                this.energyStorage.updateFromNBT();
                return CapabilityEnergy.ENERGY.orEmpty(cap, LazyOptional.of(() -> this.energyStorage));
            }
            if (cap == PowerModuleCapability.POWER_MODULE) {
                return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.moduleCap));
            }
            return LazyOptional.empty();
        }
    }
}

