/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.util.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import lehjr.numina.util.client.gui.IContainerULOffSet;
import lehjr.numina.util.client.gui.frame.IGuiFrame;
import lehjr.numina.util.client.gui.gemoetry.DrawableRelativeRect;
import lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.util.client.gui.slot.IHideableSlot;
import lehjr.numina.util.client.gui.slot.IIConProvider;
import lehjr.numina.util.math.Colour;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;

public class ExtendedContainerScreen<T extends Container>
extends ContainerScreen<T> {
    protected long creationTime;
    protected DrawableRelativeRect tooltipRect;
    protected DrawableRelativeRect backgroundRect;
    private List<IGuiFrame> frames = new ArrayList<IGuiFrame>();

    public ExtendedContainerScreen(T screenContainer, PlayerInventory inv, ITextComponent titleIn, boolean growFromMiddle) {
        super(screenContainer, inv, titleIn);
        this.tooltipRect = new DrawableRelativeRect(0.0, 0.0, 0.0, 0.0, false, Colour.BLACK.withAlpha(0.9f), Colour.PURPLE);
        this.backgroundRect = new DrawableRelativeRect(0.0, 0.0, 0.0, 0.0, growFromMiddle, Colour.GREY_GUI_BACKGROUND, Colour.BLACK);
        this.field_230706_i_ = Minecraft.func_71410_x();
    }

    public ExtendedContainerScreen(T screenContainer, PlayerInventory inv, ITextComponent titleIn, int guiWidth, int guiHeight, boolean growFromMiddle) {
        this(screenContainer, inv, titleIn, growFromMiddle);
        this.field_146999_f = guiWidth;
        this.field_147000_g = guiHeight;
    }

    MusePoint2D getUlOffset() {
        return new MusePoint2D(this.getGuiLeft(), this.getGuiTop());
    }

    public IContainerULOffSet.ulGetter ulGetter() {
        return new IContainerULOffSet.ulGetter(){

            @Override
            public MusePoint2D getULShift() {
                return ExtendedContainerScreen.this.getUlOffset();
            }
        };
    }

    protected void func_238746_a_(MatrixStack matrixStack, Slot slot) {
        if (slot != null && slot instanceof IHideableSlot) {
            if (slot.func_111238_b()) {
                super.func_238746_a_(matrixStack, slot);
            }
        } else {
            super.func_238746_a_(matrixStack, slot);
        }
        if (slot instanceof IIConProvider && slot.func_75211_c().func_190926_b() && slot.func_111238_b()) {
            this.func_230926_e_(100);
            this.field_230707_j_.field_77023_b = 100.0f;
            ((IIConProvider)slot).drawIconAt(matrixStack, slot.field_75223_e, slot.field_75221_f, Colour.WHITE);
            this.field_230707_j_.field_77023_b = 0.0f;
            this.func_230926_e_(0);
        }
    }

    public void renderBackgroundRect(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        this.backgroundRect.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
    }

    public void func_231158_b_(Minecraft minecraft, int width, int height) {
        super.func_231158_b_(minecraft, width, height);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.creationTime = System.currentTimeMillis();
        this.backgroundRect.init(this.absX(-1.0), this.absY(-1.0), this.absX(1.0), this.absY(1.0));
    }

    public void addFrame(IGuiFrame frame) {
        this.frames.add(frame);
    }

    public void func_230450_a_(MatrixStack matrixStack, float frameTime, int mouseX, int mouseY) {
        this.renderBackgroundRect(matrixStack, mouseX, mouseY, frameTime);
        this.update(mouseX, mouseY);
        this.renderFrames(matrixStack, mouseX, mouseY, frameTime);
    }

    public void update(double x, double y) {
        this.frames.forEach(frame -> frame.update(x, y));
    }

    public void renderFrames(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.frames.forEach(frame -> frame.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks));
    }

    public void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.renderFrameLabels(matrixStack, mouseX, mouseY);
    }

    public void renderFrameLabels(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.frames.forEach(frame -> frame.renderLabels(matrixStack, mouseX, mouseY));
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double dWheel) {
        if (this.frames.stream().anyMatch(frame -> frame.mouseScrolled(mouseX, mouseY, dWheel))) {
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, dWheel);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.frames.stream().anyMatch(frame -> frame.mouseClicked(mouseX, mouseY, button))) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_195362_a(Slot slot, double mouseX, double mouseY) {
        return slot.func_111238_b() && this.func_195359_a(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int which) {
        if (this.frames.stream().anyMatch(frame -> frame.mouseReleased(mouseX, mouseY, which))) {
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, which);
    }

    public void func_230459_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
        List<ITextComponent> tooltip = this.getToolTip(mouseX, mouseY);
        if (tooltip != null) {
            this.func_243308_b(matrixStack, tooltip, mouseX, mouseY);
        }
    }

    public List<ITextComponent> getToolTip(int x, int y) {
        for (IGuiFrame frame : this.frames) {
            List<ITextComponent> hitTip = frame.getToolTip(x, y);
            if (hitTip == null) continue;
            return hitTip;
        }
        return null;
    }

    public void setXSize(int xSize) {
        this.field_146999_f = xSize;
        this.field_147003_i = (this.field_230708_k_ - this.getXSize()) / 2;
    }

    public void setYSize(int ySize) {
        this.field_147000_g = ySize;
        this.field_147009_r = (this.field_230709_l_ - this.getYSize()) / 2;
    }

    public MusePoint2D center() {
        return new MusePoint2D(this.getGuiLeft(), this.getGuiTop()).plus((double)this.getXSize() * 0.5, (double)this.getYSize() * 0.5);
    }

    public int absX(double relx) {
        int absx = (int)((relx + 1.0) * (double)this.getXSize() / 2.0);
        int xpadding = (this.field_230708_k_ - this.getXSize()) / 2;
        return absx + xpadding;
    }

    public int relX(double absx) {
        int padding = (this.field_230708_k_ - this.getXSize()) / 2;
        return (int)((absx - (double)padding) * 2.0 / (double)this.getXSize() - 1.0);
    }

    public int absY(double rely) {
        int absy = (int)((rely + 1.0) * (double)this.getYSize() / 2.0);
        int ypadding = (this.field_230709_l_ - this.getYSize()) / 2;
        return absy + ypadding;
    }

    public int relY(float absy) {
        int padding = (this.field_230709_l_ - this.getYSize()) / 2;
        return (int)((absy - (float)padding) * 2.0f / (float)this.getYSize() - 1.0f);
    }

    public Minecraft getMinecraft() {
        this.field_230706_i_ = Minecraft.func_71410_x();
        return this.field_230706_i_;
    }
}

