/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.util.client.gui.clickable;

import com.mojang.blaze3d.matrix.MatrixStack;
import lehjr.numina.util.client.gui.clickable.IClickable;
import lehjr.numina.util.client.gui.gemoetry.DrawableTile;
import lehjr.numina.util.client.gui.gemoetry.IDrawable;
import lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.util.client.render.MuseRenderer;
import lehjr.numina.util.math.Colour;
import net.minecraft.util.text.ITextComponent;

public class ClickableButton2
extends DrawableTile
implements IClickable {
    boolean isVisible = true;
    boolean isEnabled = true;
    protected ITextComponent label;
    protected MusePoint2D radius;
    private Colour enabledTopBorder = Colour.WHITE.withAlpha(0.8f);
    private Colour enabledBottomBorder = Colour.getGreyscale(0.216f, 1.0f);
    private Colour enabledBackground = Colour.GREY_GUI_BACKGROUND;
    private Colour disabledTopBorder = Colour.WHITE.withAlpha(0.8f);
    private Colour disabledBottomBorder = Colour.getGreyscale(0.216f, 1.0f);
    private Colour disabledBackground = Colour.DARK_GREY.interpolate(Colour.WHITE, 0.2f);
    private IClickable.IPressable onPressed;
    private IClickable.IReleasable onReleased;

    public ClickableButton2(ITextComponent label, MusePoint2D position, boolean enabled) {
        super(1.0, 1.0, 1.0, 1.0);
        this.label = label;
        this.setPosition(position);
        if (label.getString().contains("\n")) {
            String[] x = label.getString().split("\n");
            int longestIndex = 0;
            for (int i = 0; i < x.length; ++i) {
                if (x[i].length() <= x[longestIndex].length()) continue;
                longestIndex = i;
            }
            this.radius = new MusePoint2D((float)(MuseRenderer.getStringWidth(x[longestIndex]) / 2.0 + 2.0), 6 * x.length);
        } else {
            this.radius = new MusePoint2D((float)(MuseRenderer.getStringWidth(label.getString()) / 2.0 + 2.0), 6.0);
        }
        this.setLeft(position.getX() - this.radius.getX());
        this.setTop(position.getY() - this.radius.getY());
        this.setWidth(this.radius.getX() * 2.0);
        this.setHeight(this.radius.getY() * 2.0);
        this.setEnabled(enabled);
    }

    public ClickableButton2 setEnabledTopBorder(Colour enabledTopBorder) {
        this.enabledTopBorder = enabledTopBorder;
        return this;
    }

    public ClickableButton2 setEnabledBottomBorder(Colour enabledBottomBorder) {
        this.enabledBottomBorder = enabledBottomBorder;
        return this;
    }

    public ClickableButton2 setEnabledBackground(Colour enabledBackground) {
        this.enabledBackground = enabledBackground;
        return this;
    }

    public ClickableButton2 setDisabledTopBorder(Colour disabledTopBorder) {
        this.disabledTopBorder = disabledTopBorder;
        return this;
    }

    public ClickableButton2 setDisabledBottomBorder(Colour disabledBottomBorder) {
        this.disabledBottomBorder = disabledBottomBorder;
        return this;
    }

    public ClickableButton2 setDisabledBackground(Colour disabledBackground) {
        this.disabledBackground = disabledBackground;
        return this;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderButton(matrixStack, mouseX, mouseY, partialTicks);
        this.renderText(matrixStack, mouseX, mouseY);
    }

    @Override
    public float getZLevel() {
        return 0.0f;
    }

    @Override
    public IDrawable setZLevel(float zLevel) {
        return null;
    }

    public void renderButton(MatrixStack matrixStack, int mouseX, int mouseY, float frameTIme) {
        if (this.isVisible) {
            this.setBackgroundColour(this.isEnabled() ? this.enabledBackground : this.disabledBackground);
            this.setTopBorderColour(this.isEnabled() ? this.enabledTopBorder : this.disabledTopBorder);
            this.setBottomBorderColour(this.isEnabled() ? this.enabledBottomBorder : this.disabledBottomBorder);
            super.func_230430_a_(matrixStack, mouseX, mouseY, frameTIme);
        }
    }

    public void renderText(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.isVisible()) {
            if (this.label.getString().contains("\n")) {
                String[] s = this.label.getString().split("\n");
                for (int i = 0; i < s.length; ++i) {
                    MuseRenderer.drawShadowedStringCentered(matrixStack, s[i], this.getPosition().getX(), this.getPosition().getY() + ((double)i * MuseRenderer.getStringHeight() + 1.0));
                }
            } else {
                MuseRenderer.drawCenteredText(matrixStack, this.label, this.getPosition().getX(), this.getPosition().getY() + 1.0, new Colour(0xFFFFFF));
            }
        }
    }

    public MusePoint2D getRadius() {
        return this.radius.copy();
    }

    @Override
    public boolean hitBox(double x, double y) {
        return this.containsPoint(x, y);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }

    @Override
    public void onPressed() {
        if (this.isVisible() && this.isEnabled() && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }

    @Override
    public void onReleased() {
        if (this.isVisible() && this.isEnabled() && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }

    public ClickableButton2 setLable(ITextComponent label) {
        this.label = label;
        return this;
    }

    public ITextComponent getLabel() {
        return this.label;
    }
}

