/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.util.client.gui.frame;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import lehjr.numina.util.client.gui.frame.GUISpacer;
import lehjr.numina.util.client.gui.frame.IGuiFrame;
import lehjr.numina.util.client.gui.gemoetry.IDrawable;
import lehjr.numina.util.client.gui.gemoetry.IRect;
import lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.util.math.Colour;
import net.minecraft.util.text.ITextComponent;

public abstract class RectHolderFrame<T extends IRect>
extends GUISpacer {
    T rect;
    RectPlacement placement;

    public RectHolderFrame(T rect, double widthIn, double heightIn) {
        this(rect, widthIn, heightIn, RectPlacement.CENTER);
        this.setDoThisOnChange(iChange -> this.setRect());
        this.setRect();
    }

    public RectHolderFrame(T rect, double widthIn, double heightIn, RectPlacement placement) {
        this(rect, widthIn, heightIn, placement, null);
    }

    public RectHolderFrame(T rect, double widthIn, double heightIn, RectPlacement placement, IRect.IDoThis onChange) {
        super(widthIn, heightIn);
        this.rect = rect;
        this.setBackgroundColour(Colour.YELLOW);
        this.setBorderColour(Colour.RED);
        this.placement = placement;
        this.setDoThisOnChange(iChange -> {
            if (onChange != null) {
                onChange.doThisOnChange(this);
            }
            this.setRect();
        });
        this.setRect();
    }

    @Override
    public void initGrowth() {
        super.initGrowth();
        this.rect.initGrowth();
    }

    @Override
    public void update(double mouseX, double mouseY) {
        if (this.rect instanceof IGuiFrame) {
            ((IGuiFrame)this.rect).update(mouseX, mouseY);
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
        if (this.rect instanceof IDrawable) {
            ((IDrawable)this.rect).func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
        }
    }

    @Override
    public abstract boolean mouseClicked(double var1, double var3, int var5);

    @Override
    public abstract boolean mouseReleased(double var1, double var3, int var5);

    @Override
    public abstract List<ITextComponent> getToolTip(int var1, int var2);

    public void setRect() {
        switch (this.placement) {
            case CENTER: {
                this.rect.setPosition(super.center());
                break;
            }
            case CENTER_LEFT: {
                this.rect.setPosition(new MusePoint2D(super.finalLeft() + 0.5 * this.rect.finalWidth(), super.centery()));
                break;
            }
            case CENTER_RIGHT: {
                this.rect.setPosition(new MusePoint2D(super.finalRight() - 0.5 * this.rect.finalWidth(), super.centery()));
                break;
            }
            case CENTER_TOP: {
                this.rect.setPosition(new MusePoint2D(super.centerx(), super.finalTop() + 0.5 * this.rect.finalHeight()));
                break;
            }
            case CENTER_BOTTOM: {
                this.rect.setPosition(new MusePoint2D(super.centerx(), super.finalBottom() - 0.5 * this.rect.finalHeight()));
                break;
            }
            case UPPER_LEFT: {
                this.rect.setPosition(new MusePoint2D(super.finalLeft() + 0.5 * this.rect.finalWidth(), super.finalTop() + 0.5 * this.rect.finalHeight()));
                break;
            }
            case LOWER_LEFT: {
                this.rect.setPosition(new MusePoint2D(super.finalLeft() + 0.5 * this.rect.finalWidth(), super.finalBottom() - 0.5 * this.rect.finalHeight()));
                break;
            }
            case UPPER_RIGHT: {
                this.rect.setPosition(new MusePoint2D(super.finalRight() - 0.5 * this.rect.finalWidth(), super.finalTop() + 0.5 * this.rect.finalHeight()));
                break;
            }
            case LOWER_RIGHT: {
                this.rect.setPosition(new MusePoint2D(super.finalRight() - 0.5 * this.rect.finalWidth(), super.finalBottom() - 0.5 * this.rect.finalHeight()));
            }
        }
    }

    public static enum RectPlacement {
        CENTER,
        CENTER_LEFT,
        CENTER_RIGHT,
        CENTER_TOP,
        CENTER_BOTTOM,
        UPPER_LEFT,
        LOWER_LEFT,
        UPPER_RIGHT,
        LOWER_RIGHT;

    }
}

