/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.util.client.gui.gemoetry;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.nio.FloatBuffer;
import lehjr.numina.basemod.MuseLogger;
import lehjr.numina.util.client.gui.gemoetry.GradientAndArcCalculator;
import lehjr.numina.util.client.render.NuminaRenderState;
import lehjr.numina.util.math.Colour;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.vector.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class DrawableCircle<LIGHTMAP_ENABLED> {
    protected static final RenderState.WriteMaskState COLOR_WRITE = new RenderState.WriteMaskState(true, false);
    protected static final RenderState.TransparencyState NO_TRANSPARENCY = new RenderState.TransparencyState("no_transparency", () -> RenderSystem.disableBlend(), () -> {});
    protected static final RenderState.TransparencyState ADDITIVE_TRANSPARENCY = new RenderState.TransparencyState("additive_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.TransparencyState LIGHTNING_TRANSPARENCY = new RenderState.TransparencyState("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.TransparencyState GLINT_TRANSPARENCY = new RenderState.TransparencyState("glint_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.TransparencyState CRUMBLING_TRANSPARENCY = new RenderState.TransparencyState("crumbling_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.TransparencyState TRANSLUCENT_TRANSPARENCY = new RenderState.TransparencyState("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.ShadeModelState SHADE_DISABLED = new RenderState.ShadeModelState(false);
    public static final RenderType PLASMA_BALL = RenderType.func_228633_a_((String)"plasma_ball", (VertexFormat)DefaultVertexFormats.field_227850_m_, (int)5, (int)256, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228727_a_(COLOR_WRITE).func_228723_a_(SHADE_DISABLED).func_228726_a_(ADDITIVE_TRANSPARENCY).func_228716_a_(NuminaRenderState.DIFFUSE_LIGHTING_ENABLED).func_228719_a_(NuminaRenderState.LIGHTMAP_ENABLED).func_228728_a_(true));
    public static final float detail = 4.0f;
    protected static FloatBuffer points;
    protected final FloatBuffer colour;

    public DrawableCircle(Colour c1, Colour c2) {
        FloatBuffer colourPoints;
        if (points == null) {
            colourPoints = GradientAndArcCalculator.getArcPoints(0.0f, 6.283285f, 4.0f, 0.0f, 0.0f, 0.0f);
            points = BufferUtils.createFloatBuffer((int)(colourPoints.limit() + 6));
            points.put(new float[]{0.0f, 0.0f, 0.0f});
            points.put(colourPoints);
            colourPoints.rewind();
            points.put(colourPoints.get());
            points.put(colourPoints.get());
            points.put(colourPoints.get());
            points.flip();
        }
        colourPoints = GradientAndArcCalculator.getColourGradient(c1, c1, points.limit() / 3);
        this.colour = BufferUtils.createFloatBuffer((int)(colourPoints.limit() + 4));
        this.colour.put(c2.asArray());
        this.colour.put(colourPoints);
        this.colour.flip();
    }

    public void draw(MatrixStack matrixStack, double radius, double x, double y, float zLevel) {
        float ratio = (float)(System.currentTimeMillis() % 2000L) / 2000.0f;
        this.colour.rewind();
        points.rewind();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)x, (double)y, (double)0.0);
        RenderSystem.scaled((double)(radius / 4.0), (double)(radius / 4.0), (double)1.0);
        RenderSystem.rotatef((float)((float)((double)(-ratio) * 360.0)), (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(6, DefaultVertexFormats.field_227850_m_);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        while (points.hasRemaining() && this.colour.hasRemaining()) {
            buffer.func_227888_a_(matrix4f, points.get(), points.get(), points.get()).func_227885_a_(this.colour.get(), this.colour.get(), this.colour.get(), this.colour.get()).func_227886_a_(0xF000F0).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        RenderSystem.popMatrix();
    }

    void testDraw(double radius, double x, double y) {
        points.rewind();
        this.colour.rewind();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glScaled((double)(radius / 4.0), (double)(radius / 4.0), (double)1.0);
        NuminaRenderState.on2D();
        GL11.glEnable((int)2929);
        NuminaRenderState.arraysOnColor();
        NuminaRenderState.texturelessOn();
        NuminaRenderState.blendingOn();
        GL11.glColorPointer((int)4, (int)5126, (int)0, (FloatBuffer)this.colour);
        GL11.glVertexPointer((int)3, (int)5126, (int)0, (FloatBuffer)points);
        GL11.glDrawArrays((int)6, (int)0, (int)(points.limit() / 3));
        NuminaRenderState.blendingOff();
        NuminaRenderState.texturelessOff();
        NuminaRenderState.arraysOff();
        NuminaRenderState.off2D();
        GL11.glPopMatrix();
    }

    public void draw(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float radius, float x, float y, float z) {
        this.drawSphere(matrixStackIn, bufferIn, x, y, y, radius, 1, 1);
    }

    public void drawSphere(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float x, float y, float z, float radius, int stacks, int slices) {
        Colour colourTest = Colour.MAGENTA.withAlpha(0.3f);
        float stackStep = (float)(Math.PI / (double)stacks);
        float sliceStep = (float)(Math.PI / (double)slices);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_((double)x, (double)y, (double)z);
        IVertexBuilder vertBuffer = bufferIn.getBuffer(PLASMA_BALL);
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        int vertices = 0;
        int numVertices = slices * (slices << 1) * 6;
        for (int i = 0; i < stacks; ++i) {
            float alpha0 = (float)(-1.5707963267948966 + (double)((float)i * stackStep));
            float alpha1 = alpha0 + stackStep;
            float r0 = (float)((double)radius * Math.cos(alpha0));
            float r1 = (float)((double)radius * Math.cos(alpha1));
            float y0 = (float)((double)radius * Math.sin(alpha0));
            float y1 = (float)((double)radius * Math.sin(alpha1));
            for (int j = 0; j < slices << 1; ++j) {
                float beta = (float)j * sliceStep;
                float x0 = (float)((double)r0 * Math.cos(beta));
                float x1 = (float)((double)r1 * Math.cos(beta));
                float z0 = (float)((double)(-r0) * Math.sin(beta));
                float z1 = (float)((double)(-r1) * Math.sin(beta));
                vertBuffer.func_227888_a_(matrix4f, x0, y0, z0).func_227885_a_(colourTest.r, colourTest.g, colourTest.b, colourTest.a).func_227886_a_(0xF000F0).func_181675_d();
                vertBuffer.func_227888_a_(matrix4f, x1, y1, z1).func_227885_a_(colourTest.r, colourTest.g, colourTest.b, colourTest.a).func_227886_a_(0xF000F0).func_181675_d();
                vertices += 6;
                MuseLogger.logDebug("j: " + j);
            }
        }
        matrixStackIn.func_227865_b_();
        MuseLogger.logDebug("vertices: " + vertices);
        MuseLogger.logDebug("numVertices: " + numVertices);
    }
}

