/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.util.client.gui.slot;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.client.gui.clickable.IClickable;
import lehjr.numina.util.client.gui.gemoetry.IRect;
import lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.util.client.gui.slot.UniversalSlot;
import lehjr.numina.util.client.render.MuseIconUtils;
import lehjr.numina.util.client.render.MuseRenderer;
import lehjr.numina.util.math.Colour;
import lehjr.numina.util.string.MuseStringUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;

public class ClickableModuleSlot
extends UniversalSlot
implements IClickable {
    protected IClickable.IPressable onPressed;
    protected IClickable.IReleasable onReleased;
    boolean isVisible = true;
    boolean isEnabled = true;
    final Colour checkmarkcolour = new Colour(0.0f, 0.667f, 0.0f, 1.0f);
    boolean allowed = true;
    boolean installed = false;

    public ClickableModuleSlot(IInventory inventory, int index, int xPosition, int yPosition) {
        this(inventory, index, new MusePoint2D(xPosition, yPosition));
    }

    public ClickableModuleSlot(IInventory inventory, int index, MusePoint2D position) {
        super(inventory, index, (int)position.getX(), (int)position.getY());
    }

    public ClickableModuleSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        this(itemHandler, index, new MusePoint2D(xPosition, yPosition));
    }

    public ClickableModuleSlot(IItemHandler itemHandler, int index, MusePoint2D position) {
        super(itemHandler, index, (int)position.getX(), (int)position.getY());
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.func_75211_c().func_190926_b()) {
            MuseRenderer.drawItemAt(this.getUL().getX(), this.getUL().getY(), this.func_75211_c());
            if (!this.allowed) {
                String string = MuseStringUtils.wrapFormatTags("x", MuseStringUtils.FormatCodes.DarkRed);
                MuseRenderer.drawShadowedString(matrixStack, string, this.getPosition().getX() + 3.0, this.getPosition().getY() + 1.0);
            } else if (this.installed) {
                MuseIconUtils.getIcon().checkmark.draw(matrixStack, this.getUL().getX() + 1.0, this.getUL().getY() + 1.0, this.checkmarkcolour);
            }
        }
    }

    @Override
    public void doThisOnChange() {
    }

    @Override
    public void setDoThisOnChange(IRect.IDoThis iDoThis) {
    }

    @Override
    public List<ITextComponent> getToolTip(int x, int y) {
        if (this.hitBox(x, y)) {
            ArrayList<ITextComponent> toolTipText = new ArrayList<ITextComponent>();
            toolTipText.add(this.getLocalizedName());
            toolTipText.addAll(MuseStringUtils.wrapITextComponentToLength(this.getLocalizedDescription(), 30));
            return toolTipText;
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.isEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void onReleased() {
        if (this.isVisible && this.isEnabled && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }

    @Override
    public void onPressed() {
        if (this.isVisible && this.isEnabled && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }

    public ITextComponent getLocalizedName() {
        if (this.func_75211_c().func_190926_b()) {
            return null;
        }
        return this.func_75211_c().func_151000_E();
    }

    public ITextComponent getLocalizedDescription() {
        if (this.func_75211_c().func_190926_b()) {
            return null;
        }
        return new TranslationTextComponent(this.func_75211_c().func_77973_b().func_77658_a().concat(".desc"));
    }

    public ModuleCategory getCategory() {
        return this.func_75211_c().getCapability(PowerModuleCapability.POWER_MODULE).map(m -> m.getCategory()).orElse(ModuleCategory.NONE);
    }

    public boolean equals(ClickableModuleSlot other) {
        return this.func_75211_c().func_77969_a(other.func_75211_c());
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }
}

