/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.util.heat;

import com.google.common.util.concurrent.AtomicDouble;
import javax.annotation.Nonnull;
import lehjr.numina.util.capabilities.heat.HeatCapability;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class MuseHeatUtils {
    public static final DamageSource overheatDamage = new OverheatDamage();

    public static double getPlayerHeat(LivingEntity entity) {
        double heat = 0.0;
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            heat += MuseHeatUtils.getItemHeat(entity.func_184582_a(slot));
        }
        return heat;
    }

    public static double getPlayerMaxHeat(LivingEntity entity) {
        AtomicDouble maxHeat = new AtomicDouble(0.0);
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack itemStack = entity.func_184582_a(slot);
            if (!slot.func_188453_a().equals((Object)EquipmentSlotType.Group.ARMOR) && (!slot.func_188453_a().equals((Object)EquipmentSlotType.Group.HAND) || itemStack.func_77973_b() instanceof ArmorItem)) continue;
            itemStack.getCapability(HeatCapability.HEAT).ifPresent(heat -> maxHeat.getAndAdd(heat.getMaxHeatStored()));
        }
        return maxHeat.get();
    }

    public static double coolPlayer(LivingEntity entity, double coolJoules) {
        if (entity.field_70170_p.field_72995_K) {
            return 0.0;
        }
        double coolingLeft = coolJoules;
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (entity.func_184587_cr() && player.field_71071_by.func_70448_g() == stack) continue;
                if (coolingLeft > 0.0) {
                    coolingLeft -= MuseHeatUtils.coolItem(stack, coolingLeft);
                    continue;
                }
                break;
            }
        } else {
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                if (coolingLeft > 0.0) {
                    coolingLeft -= MuseHeatUtils.coolItem(entity.func_184582_a(slot), coolingLeft);
                    continue;
                }
                break;
            }
        }
        return coolJoules - coolingLeft;
    }

    public static double heatPlayer(LivingEntity entity, double heatJoules) {
        if (entity.field_70170_p.field_72995_K) {
            return 0.0;
        }
        double heatLeftToGive = heatJoules;
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            if (heatLeftToGive == 0.0) break;
            heatLeftToGive -= MuseHeatUtils.heatItem(entity.func_184582_a(slot), heatLeftToGive);
        }
        return heatLeftToGive;
    }

    public static void heatEntity(LivingAttackEvent event) {
        if (event.getSource().func_76347_k()) {
            double heatLeftToGive;
            double originalHeatToGive = heatLeftToGive = (double)Math.round(event.getAmount());
            LivingEntity entity = event.getEntityLiving();
            boolean allPresent = true;
            for (ItemStack stack : entity.func_184193_aE()) {
                if (stack.getCapability(HeatCapability.HEAT).isPresent()) continue;
                allPresent = false;
                break;
            }
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                if (heatLeftToGive == 0.0) break;
                double finalHeatLeftToGive = heatLeftToGive;
                heatLeftToGive -= entity.func_184582_a(slot).getCapability(HeatCapability.HEAT).map(heat -> heat.receiveHeat(finalHeatLeftToGive, false)).orElse(0.0).doubleValue();
            }
            if (heatLeftToGive < originalHeatToGive) {
                if (allPresent) {
                    event.setCanceled(true);
                }
                if (heatLeftToGive > 0.0) {
                    entity.func_70097_a((DamageSource)new OverheatDamage(), (float)heatLeftToGive);
                }
            }
        }
    }

    public static double getItemMaxHeat(@Nonnull ItemStack stack) {
        return stack.getCapability(HeatCapability.HEAT).map(h -> h.getMaxHeatStored()).orElse(0.0);
    }

    public static double getItemHeat(@Nonnull ItemStack stack) {
        return stack.getCapability(HeatCapability.HEAT).map(h -> h.getHeatStored()).orElse(0.0);
    }

    public static double heatItem(@Nonnull ItemStack stack, double value) {
        return stack.getCapability(HeatCapability.HEAT, null).map(h -> h.receiveHeat(value, false)).orElse(0.0);
    }

    public static double coolItem(@Nonnull ItemStack stack, double value) {
        return stack.getCapability(HeatCapability.HEAT, null).map(h -> h.extractHeat(value, false)).orElse(0.0);
    }

    protected static final class OverheatDamage
    extends DamageSource {
        public OverheatDamage() {
            super("Overheat");
            this.func_76361_j();
            this.func_76348_h();
        }

        public boolean equals(DamageSource other) {
            return other.field_76373_n.equals(this.field_76373_n);
        }
    }
}

