/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.util.string;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class MuseStringUtils {
    public static final char[] smallSuffixes = new char[]{'m', '\u03bc', 'n', 'p', 'f', 'a', 'z', 'y'};
    public static final char[] bigSuffixes = new char[]{'k', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'};

    public static String extractName(ResourceLocation resource) {
        return MuseStringUtils.extractName(resource.toString());
    }

    public static String extractName(String filename) {
        int ix = Math.max(filename.lastIndexOf(47), Math.max(filename.lastIndexOf(92), filename.lastIndexOf(58))) + 1;
        return filename.substring(ix, filename.lastIndexOf(46)).trim();
    }

    public static String formatNumberShort(double number) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(2);
        format.applyPattern("##0.##E0");
        String[] exploded = format.format(number).split("E");
        String retval = exploded[0];
        if (retval.length() > 3) {
            retval = retval.charAt(3) == '.' ? retval.substring(0, 3) : retval.substring(0, 4);
        }
        if (exploded.length > 1) {
            int exponent = Integer.parseInt(exploded[1]);
            if (exponent > 0) {
                int index = exponent / 3 - 1;
                retval = index > bigSuffixes.length - 1 ? "Infinite M" : retval + bigSuffixes[index];
            } else if (exponent < 0) {
                int index = exponent / -3 - 1;
                retval = retval + smallSuffixes[index];
            }
        }
        return retval;
    }

    public static String formatNumberPercent(double number) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(2);
        format.applyPattern("##0.##");
        return format.format(number * 100.0);
    }

    public static String formatNumberFromUnits(double number, String units) {
        if (units.equals("%")) {
            return MuseStringUtils.formatNumberPercent(number) + '%';
        }
        return MuseStringUtils.formatNumberShort(number) + units;
    }

    public static String prependFormatTag(String str, char format) {
        return "\u00a7" + format + str;
    }

    public static String appendResetTag(String str) {
        return str + "\u00a7r";
    }

    public static String wrapFormatTags(String str, char format) {
        return MuseStringUtils.appendResetTag(MuseStringUtils.prependFormatTag(str, format));
    }

    public static String wrapFormatTags(String str, FormatCodes code) {
        return MuseStringUtils.wrapFormatTags(str, code.character);
    }

    public static String wrapMultipleFormatTags(String str, Object ... tags) {
        for (Object tag : tags) {
            if (tag instanceof Character) {
                str = MuseStringUtils.prependFormatTag(str, ((Character)tag).charValue());
                continue;
            }
            if (!(tag instanceof FormatCodes)) continue;
            str = MuseStringUtils.prependFormatTag(str, ((FormatCodes)((Object)tag)).character);
        }
        return MuseStringUtils.appendResetTag(str);
    }

    public static List<ITextComponent> wrapStringToLength(String str, int length) {
        if (str == null) {
            str = "";
        }
        String[] stringArray = MuseStringUtils.wordUtilsWrap(str, length);
        ArrayList<ITextComponent> retList = new ArrayList<ITextComponent>();
        for (String s : stringArray) {
            retList.add((ITextComponent)new StringTextComponent(s));
        }
        return retList;
    }

    static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static String[] wordUtilsWrap(String str, int wrapLength) {
        if (str == null) {
            return null;
        }
        String newLineStr = System.lineSeparator();
        String wrapOn = " ";
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        if (MuseStringUtils.isBlank(wrapOn)) {
            wrapOn = " ";
        }
        Pattern patternToWrapOn = Pattern.compile(wrapOn);
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        while (offset < inputLineLength) {
            int spaceToWrapAt = -1;
            Matcher matcher = patternToWrapOn.matcher(str.substring(offset, Math.min((int)Math.min(Integer.MAX_VALUE, (long)(offset + wrapLength) + 1L), inputLineLength)));
            if (matcher.find()) {
                if (matcher.start() == 0) {
                    offset += matcher.end();
                    continue;
                }
                spaceToWrapAt = matcher.start() + offset;
            }
            if (inputLineLength - offset <= wrapLength) break;
            while (matcher.find()) {
                spaceToWrapAt = matcher.start() + offset;
            }
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            matcher = patternToWrapOn.matcher(str.substring(offset + wrapLength));
            if (matcher.find()) {
                spaceToWrapAt = matcher.start() + offset + wrapLength;
            }
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str, offset, str.length());
            offset = inputLineLength;
        }
        wrappedLine.append(str, offset, str.length());
        return wrappedLine.toString().split(System.lineSeparator());
    }

    public static List<ITextComponent> wrapITextComponentToLength(ITextComponent component, int length) {
        if (component == null) {
            component = new StringTextComponent("");
        }
        return MuseStringUtils.wrapStringToLength(component.func_150261_e(), length);
    }

    public static List<String> wrapStringToVisualLength(String str, double length) {
        ArrayList<String> strlist = new ArrayList<String>();
        String[] words = str.split(" ");
        if (words.length == 0) {
            return null;
        }
        String currLine = words[0];
        for (int i = 1; i < words.length; ++i) {
            String approxLine = currLine + " " + words[i];
            if ((double)Minecraft.func_71410_x().field_71466_p.func_78256_a(approxLine) > length) {
                strlist.add(currLine);
                currLine = " " + words[i];
                continue;
            }
            currLine = approxLine;
        }
        strlist.add(currLine);
        return strlist;
    }

    public static enum FormatCodes {
        Black('0'),
        DarkBlue('1'),
        DarkGreen('2'),
        DarkAqua('3'),
        DarkRed('4'),
        Purple('5'),
        Gold('6'),
        Grey('7'),
        DarkGrey('8'),
        Indigo('9'),
        BrightGreen('a'),
        Aqua('b'),
        Red('c'),
        Pink('d'),
        Yellow('e'),
        White('f'),
        RandomChar('k'),
        Bold('l'),
        Strike('m'),
        Underlined('n'),
        Italic('o'),
        Reset('r');

        public final char character;

        private FormatCodes(char character) {
            this.character = character;
        }
    }
}

