/*
 * Decompiled with CFR 0.152.
 */
package me.lambdaurora.lambdynlights.api;

import java.util.HashMap;
import java.util.Map;
import me.lambdaurora.lambdynlights.DynamicLightsReforged;
import me.lambdaurora.lambdynlights.api.DynamicLightHandler;
import me.lambdaurora.lambdynlights.config.DynamicLightsConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DynamicLightHandlers {
    private static Map<EntityType<? extends Entity>, DynamicLightHandler<? extends Entity>> ENTITES_HANDLER = new HashMap<EntityType<? extends Entity>, DynamicLightHandler<? extends Entity>>();
    private static Map<TileEntityType<? extends TileEntity>, DynamicLightHandler<? extends TileEntity>> BLOCK_ENTITIES_HANDLER = new HashMap<TileEntityType<? extends TileEntity>, DynamicLightHandler<? extends TileEntity>>();

    private DynamicLightHandlers() {
        throw new UnsupportedOperationException("DynamicLightHandlers only contains static definitions.");
    }

    public static void registerDefaultHandlers() {
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.field_200792_f, DynamicLightHandler.makeHandler(blaze -> 10, blaze -> true));
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.field_200797_k, DynamicLightHandler.makeCreeperEntityHandler(null));
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.field_200803_q, (T entity) -> {
            int luminance = 0;
            if (entity.func_195405_dq() != null) {
                luminance = entity.func_195405_dq().func_185906_d();
            }
            return luminance;
        });
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.field_200765_E, (T entity) -> DynamicLightsReforged.getLuminanceFromItemStack(entity.func_92059_d(), entity.func_204231_K()));
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.field_200766_F, (T entity) -> {
            World world = entity.func_130014_f_();
            return DynamicLightsReforged.getLuminanceFromItemStack(entity.func_82335_i(), !world.func_204610_c(entity.func_233580_cy_()).func_206888_e());
        });
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.field_200771_K, (T entity) -> (double)entity.field_70811_b > 0.6 ? 11 : 8);
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.field_200747_am, (T entity) -> 8);
    }

    public static <T extends Entity> void registerDynamicLightHandler(@NotNull EntityType<T> type, @NotNull DynamicLightHandler<T> handler) {
        DynamicLightHandler registeredHandler = DynamicLightHandlers.getDynamicLightHandler(type);
        if (registeredHandler != null) {
            DynamicLightHandler<Entity> newHandler = entity -> Math.max(registeredHandler.getLuminance(entity), handler.getLuminance(entity));
            ENTITES_HANDLER.put(type, newHandler);
        }
        ENTITES_HANDLER.put(type, handler);
    }

    public static <T extends TileEntity> void registerDynamicLightHandler(@NotNull TileEntityType<T> type, @NotNull DynamicLightHandler<T> handler) {
        DynamicLightHandler registeredHandler = DynamicLightHandlers.getDynamicLightHandler(type);
        if (registeredHandler != null) {
            DynamicLightHandler<TileEntity> newHandler = entity -> Math.max(registeredHandler.getLuminance(entity), handler.getLuminance(entity));
            BLOCK_ENTITIES_HANDLER.put(type, newHandler);
        }
        BLOCK_ENTITIES_HANDLER.put(type, handler);
    }

    @Nullable
    public static <T extends Entity> DynamicLightHandler<T> getDynamicLightHandler(@NotNull EntityType<T> type) {
        return ENTITES_HANDLER.get(type);
    }

    @Nullable
    public static <T extends TileEntity> DynamicLightHandler<T> getDynamicLightHandler(@NotNull TileEntityType<T> type) {
        return BLOCK_ENTITIES_HANDLER.get(type);
    }

    public static <T extends Entity> int getLuminanceFrom(@NotNull T entity) {
        if (!((Boolean)DynamicLightsConfig.EntityLighting.get()).booleanValue()) {
            return 0;
        }
        DynamicLightHandler<T> handler = DynamicLightHandlers.getDynamicLightHandler(entity.func_200600_R());
        if (handler == null) {
            return 0;
        }
        if (handler.isWaterSensitive(entity) && !entity.func_130014_f_().func_204610_c(new BlockPos(entity.func_226277_ct_(), entity.func_226280_cw_(), entity.func_226281_cx_())).func_206888_e()) {
            return 0;
        }
        return handler.getLuminance(entity);
    }

    public static <T extends TileEntity> int getLuminanceFrom(@NotNull T entity) {
        if (!((Boolean)DynamicLightsConfig.TileEntityLighting.get()).booleanValue()) {
            return 0;
        }
        DynamicLightHandler<T> handler = DynamicLightHandlers.getDynamicLightHandler(entity.func_200662_C());
        if (handler == null) {
            return 0;
        }
        if (handler.isWaterSensitive(entity) && entity.func_145831_w() != null && !entity.func_145831_w().func_204610_c(entity.func_174877_v()).func_206888_e()) {
            return 0;
        }
        return handler.getLuminance(entity);
    }
}

