/*
 * Decompiled with CFR 0.152.
 */
package org.aperlambda.lambdacommon.config.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.aperlambda.lambdacommon.LambdaConstants;
import org.aperlambda.lambdacommon.config.json.BaseJsonConfig;
import org.aperlambda.lambdacommon.config.json.JsonConfig;
import org.jetbrains.annotations.NotNull;

public class VirtualJsonConfig
implements BaseJsonConfig {
    private JsonObject config = new JsonObject();

    public VirtualJsonConfig() {
    }

    public VirtualJsonConfig(@NotNull JsonObject root) {
        this.config = root;
    }

    @Override
    public <T> T get(String key, T def, Class<T> type) {
        return JsonConfig.jsonGet(this.config, key, def, type);
    }

    @Override
    public void set(String key, Object value) {
        if (key.contains(".")) {
            String[] path = key.split("\\.");
            JsonObject currentObject = this.config;
            for (int i = 0; i < path.length - 1; ++i) {
                String currentKey = path[i];
                if (!currentObject.has(currentKey)) {
                    currentObject.add(currentKey, (JsonElement)new JsonObject());
                }
                currentObject = currentObject.getAsJsonObject(currentKey);
            }
            currentObject.add(path[path.length - 1], LambdaConstants.GSON_PRETTY.toJsonTree(value));
        } else {
            this.config.add(key, LambdaConstants.GSON_PRETTY.toJsonTree(value));
        }
    }

    @Override
    public <T> T at(String path, T def, Class<T> type) {
        return JsonConfig.jsonAt(this.config, path, def, type);
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public JsonObject getConfig() {
        return this.config;
    }
}

