/*
 * Decompiled with CFR 0.152.
 */
package org.aperlambda.lambdacommon.utils;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.aperlambda.lambdacommon.utils.function.PairFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Pair<K, V>
implements Serializable {
    public final K key;
    public final V value;

    public Pair(@Nullable K first, @Nullable V second) {
        this.key = first;
        this.value = second;
    }

    public static <K, V> Pair<K, V> of(@Nullable K first, @Nullable V second) {
        return new Pair<K, V>(first, second);
    }

    public static <K, V> Pair<K, V> fromEntry(Map.Entry<K, V> entry) {
        return new Pair<K, V>(entry.getKey(), entry.getValue());
    }

    public static <K, V> List<Pair<K, V>> newListFromMap(Map<K, V> map) {
        ArrayList list = new ArrayList();
        map.forEach((key, value) -> list.add(new Pair<Object, Object>(key, value)));
        return list;
    }

    public K getFirst() {
        return this.key;
    }

    public V getSecond() {
        return this.value;
    }

    @NotNull
    public <M, N> Pair<? extends M, ? extends N> map(@NotNull PairFunction<K, V, ? extends M, ? extends N> mapper) {
        Objects.requireNonNull(mapper);
        return mapper.apply(this);
    }

    @NotNull
    public <N> Optional<N> mapSecond(@NotNull Function<? super V, ? extends N> mapper) {
        Objects.requireNonNull(mapper);
        return this.value == null ? Optional.empty() : Optional.ofNullable(mapper.apply(this.value));
    }

    public Stream<Pair<K, V>> stream() {
        return Stream.of(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return Objects.equals(this.key, pair.key) && Objects.equals(this.value, pair.value);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Pair{first: " + this.key + ", second: " + this.value + '}';
    }

    public static class JsonPairSerializer
    implements JsonSerializer<Pair<?, ?>>,
    JsonDeserializer<Pair<?, ?>> {
        public JsonElement serialize(Pair<?, ?> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            if (src.key != null) {
                JsonObject jsonFirst = new JsonObject();
                jsonFirst.addProperty("type", src.key.getClass().getName());
                jsonFirst.add("data", context.serialize(src.key));
                json.add("first", (JsonElement)jsonFirst);
            } else {
                json.add("first", (JsonElement)JsonNull.INSTANCE);
            }
            Object value = src.value;
            if (value != null) {
                JsonObject jsonSecond = new JsonObject();
                jsonSecond.addProperty("type", value.getClass().getName());
                jsonSecond.add("data", context.serialize(value));
                json.add("second", (JsonElement)jsonSecond);
            } else {
                json.add("second", (JsonElement)JsonNull.INSTANCE);
            }
            return json;
        }

        public Pair<?, ?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!(json instanceof JsonObject)) {
                throw new JsonParseException("Cannot parse Pair<?, ?>: the json must be an object!");
            }
            JsonObject obj = (JsonObject)json;
            Object key = null;
            try {
                if (obj.has("first") && !obj.get("first").isJsonNull()) {
                    JsonObject jsonFirst = obj.getAsJsonObject("first");
                    Class<?> type = Class.forName(jsonFirst.get("type").getAsString());
                    key = context.deserialize(jsonFirst.get("data"), type);
                }
                if (!obj.has("second") || obj.get("second").isJsonNull()) {
                    return Pair.of(key, null);
                }
                JsonObject jsonSecond = obj.getAsJsonObject("value");
                Class<?> valueType = Class.forName(jsonSecond.get("type").getAsString());
                Object value = context.deserialize(jsonSecond.get("data"), valueType);
                return Pair.of(key, value);
            }
            catch (ClassNotFoundException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }
}

