/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.quad.blender;

import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.BiomeColorBlender;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import me.jellysquid.mods.sodium.client.util.color.ColorMixer;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockDisplayReader;

public class SmoothBiomeColorBlender
implements BiomeColorBlender {
    private final int[] cachedRet = new int[4];
    private final BlockPos.Mutable mpos = new BlockPos.Mutable();

    @Override
    public int[] getColors(IBlockColor colorizer, IBlockDisplayReader world, BlockState state, BlockPos origin, ModelQuadView quad) {
        int[] colors = this.cachedRet;
        for (int i = 0; i < 4; ++i) {
            colors[i] = this.getInterpolatedVertexColor(colorizer, world, state, origin, quad, i);
        }
        return colors;
    }

    private int getBlockColor(IBlockColor colorizer, IBlockDisplayReader world, BlockState state, int x, int y, int z, int colorIdx) {
        return colorizer.getColor(state, world, (BlockPos)this.mpos.func_181079_c(x, y, z), colorIdx);
    }

    private int getInterpolatedVertexColor(IBlockColor colorizer, IBlockDisplayReader world, BlockState state, BlockPos origin, ModelQuadView quad, int vertexIdx) {
        float x = MathHelper.func_76131_a((float)quad.getX(vertexIdx), (float)-1.0f, (float)2.0f) - 0.5f;
        float y = MathHelper.func_76131_a((float)quad.getY(vertexIdx), (float)-1.0f, (float)2.0f) - 0.5f;
        float z = MathHelper.func_76131_a((float)quad.getZ(vertexIdx), (float)-1.0f, (float)2.0f) - 0.5f;
        int intX = (int)Math.floor(x);
        int intY = (int)Math.floor(y);
        int intZ = (int)Math.floor(z);
        int originX = origin.func_177958_n() + intX;
        int originY = origin.func_177956_o() + intY;
        int originZ = origin.func_177952_p() + intZ;
        int c000 = this.getBlockColor(colorizer, world, state, originX, originY, originZ, quad.getColorIndex());
        int c001 = this.getBlockColor(colorizer, world, state, originX, originY, originZ + 1, quad.getColorIndex());
        int c100 = this.getBlockColor(colorizer, world, state, originX + 1, originY, originZ, quad.getColorIndex());
        int c101 = this.getBlockColor(colorizer, world, state, originX + 1, originY, originZ + 1, quad.getColorIndex());
        int c010 = this.getBlockColor(colorizer, world, state, originX, originY + 1, originZ, quad.getColorIndex());
        int c011 = this.getBlockColor(colorizer, world, state, originX, originY + 1, originZ + 1, quad.getColorIndex());
        int c110 = this.getBlockColor(colorizer, world, state, originX + 1, originY + 1, originZ, quad.getColorIndex());
        int c111 = this.getBlockColor(colorizer, world, state, originX + 1, originY + 1, originZ + 1, quad.getColorIndex());
        float fracX = x - (float)intX;
        float fracY = y - (float)intY;
        float fracZ = z - (float)intZ;
        int dx1 = ColorMixer.getStartRatio(fracX);
        int dx2 = ColorMixer.getEndRatio(fracX);
        int dy1 = ColorMixer.getStartRatio(fracY);
        int dy2 = ColorMixer.getEndRatio(fracY);
        int dz1 = ColorMixer.getStartRatio(fracZ);
        int dz2 = ColorMixer.getEndRatio(fracZ);
        int c00 = ColorMixer.mixARGB(c000, c001, dz1, dz2);
        int c01 = ColorMixer.mixARGB(c100, c101, dz1, dz2);
        int c10 = ColorMixer.mixARGB(c010, c011, dz1, dz2);
        int c11 = ColorMixer.mixARGB(c110, c111, dz1, dz2);
        int c0 = ColorMixer.mixARGB(c00, c01, dy1, dy2);
        int c1 = ColorMixer.mixARGB(c10, c11, dy1, dy2);
        int c = ColorMixer.mixARGB(c0, c1, dx1, dx2);
        return ColorARGB.toABGR(c);
    }
}

