/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.FloatBuffer;
import java.util.function.Function;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.render.GameRendererContext;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderFogComponent;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.system.MemoryStack;

public class ChunkProgram
extends GlProgram {
    private final int uModelViewProjectionMatrix = this.getUniformLocation("u_ModelViewProjectionMatrix");
    private final int uModelScale;
    private final int uTextureScale;
    private final int uBlockTex = this.getUniformLocation("u_BlockTex");
    private final int uLightTex = this.getUniformLocation("u_LightTex");
    private final ChunkShaderFogComponent fogShader;

    protected ChunkProgram(RenderDevice owner, ResourceLocation name, int handle, Function<ChunkProgram, ChunkShaderFogComponent> fogShaderFunction) {
        super(owner, name, handle);
        this.uModelScale = this.getUniformLocation("u_ModelScale");
        this.uTextureScale = this.getUniformLocation("u_TextureScale");
        this.fogShader = fogShaderFunction.apply(this);
    }

    public void setup(MatrixStack matrixStack, float modelScale, float textureScale) {
        GL20C.glUniform1i((int)this.uBlockTex, (int)0);
        GL20C.glUniform1i((int)this.uLightTex, (int)2);
        GL20C.glUniform3f((int)this.uModelScale, (float)modelScale, (float)modelScale, (float)modelScale);
        GL20C.glUniform2f((int)this.uTextureScale, (float)textureScale, (float)textureScale);
        this.fogShader.setup();
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            GL20C.glUniformMatrix4fv((int)this.uModelViewProjectionMatrix, (boolean)false, (FloatBuffer)GameRendererContext.getModelViewProjectionMatrix(matrixStack.func_227866_c_(), memoryStack));
        }
    }
}

