/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.biome;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.world.ClientWorldExtended;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.IBiomeMagnifier;

public class BiomeCache {
    private final IBiomeMagnifier type;
    private final long seed;
    private final Biome[] biomes;

    public BiomeCache(World world) {
        this.type = world.func_230315_m_().func_227176_e_();
        this.seed = ((ClientWorldExtended)world).getBiomeSeed();
        this.biomes = new Biome[256];
    }

    public Biome getBiome(BiomeManager.IBiomeReader storage, int x, int y, int z) {
        int idx = (z & 0xF) << 4 | x & 0xF;
        Biome biome = this.biomes[idx];
        if (biome == null) {
            this.biomes[idx] = biome = this.type.func_225532_a_(this.seed, x, y, z, storage);
        }
        return biome;
    }

    public void reset() {
        Arrays.fill(this.biomes, null);
    }
}

