/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core.matrix;

import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.math.Matrix3fExtended;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3i;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Matrix3f.class})
public class MixinMatrix3f
implements Matrix3fExtended {
    @Shadow
    protected float field_226097_a_;
    @Shadow
    protected float field_226100_d_;
    @Shadow
    protected float field_226103_g_;
    @Shadow
    protected float field_226098_b_;
    @Shadow
    protected float field_226101_e_;
    @Shadow
    protected float field_226104_h_;
    @Shadow
    protected float field_226099_c_;
    @Shadow
    protected float field_226102_f_;
    @Shadow
    protected float field_226105_i_;

    @Override
    public float transformVecX(float x, float y, float z) {
        return this.field_226097_a_ * x + this.field_226098_b_ * y + this.field_226099_c_ * z;
    }

    @Override
    public float transformVecY(float x, float y, float z) {
        return this.field_226100_d_ * x + this.field_226101_e_ * y + this.field_226102_f_ * z;
    }

    @Override
    public float transformVecZ(float x, float y, float z) {
        return this.field_226103_g_ * x + this.field_226104_h_ * y + this.field_226105_i_ * z;
    }

    @Override
    public void rotate(Quaternion quaternion) {
        boolean z;
        boolean x = quaternion.func_195889_a() != 0.0f;
        boolean y = quaternion.func_195891_b() != 0.0f;
        boolean bl = z = quaternion.func_195893_c() != 0.0f;
        if (x) {
            if (!y && !z) {
                this.rotateX(quaternion);
            } else {
                this.rotateXYZ(quaternion);
            }
        } else if (y) {
            if (!z) {
                this.rotateY(quaternion);
            } else {
                this.rotateXYZ(quaternion);
            }
        } else if (z) {
            this.rotateZ(quaternion);
        }
    }

    @Override
    public int computeNormal(Direction dir) {
        Vector3i faceNorm = dir.func_176730_m();
        float x = faceNorm.func_177958_n();
        float y = faceNorm.func_177956_o();
        float z = faceNorm.func_177952_p();
        float x2 = this.field_226097_a_ * x + this.field_226098_b_ * y + this.field_226099_c_ * z;
        float y2 = this.field_226100_d_ * x + this.field_226101_e_ * y + this.field_226102_f_ * z;
        float z2 = this.field_226103_g_ * x + this.field_226104_h_ * y + this.field_226105_i_ * z;
        return Norm3b.pack(x2, y2, z2);
    }

    private void rotateX(Quaternion quaternion) {
        float x = quaternion.func_195889_a();
        float w = quaternion.func_195894_d();
        float xx = 2.0f * x * x;
        float ta11 = 1.0f - xx;
        float ta22 = 1.0f - xx;
        float xw = x * w;
        float ta21 = 2.0f * xw;
        float ta12 = 2.0f * -xw;
        float a01 = this.field_226098_b_ * ta11 + this.field_226099_c_ * ta21;
        float a02 = this.field_226098_b_ * ta12 + this.field_226099_c_ * ta22;
        float a11 = this.field_226101_e_ * ta11 + this.field_226102_f_ * ta21;
        float a12 = this.field_226101_e_ * ta12 + this.field_226102_f_ * ta22;
        float a21 = this.field_226104_h_ * ta11 + this.field_226105_i_ * ta21;
        float a22 = this.field_226104_h_ * ta12 + this.field_226105_i_ * ta22;
        this.field_226098_b_ = a01;
        this.field_226099_c_ = a02;
        this.field_226101_e_ = a11;
        this.field_226102_f_ = a12;
        this.field_226104_h_ = a21;
        this.field_226105_i_ = a22;
    }

    private void rotateY(Quaternion quaternion) {
        float y = quaternion.func_195891_b();
        float w = quaternion.func_195894_d();
        float yy = 2.0f * y * y;
        float ta00 = 1.0f - yy;
        float ta22 = 1.0f - yy;
        float yw = y * w;
        float ta20 = 2.0f * -yw;
        float ta02 = 2.0f * yw;
        float a00 = this.field_226097_a_ * ta00 + this.field_226099_c_ * ta20;
        float a02 = this.field_226097_a_ * ta02 + this.field_226099_c_ * ta22;
        float a10 = this.field_226100_d_ * ta00 + this.field_226102_f_ * ta20;
        float a12 = this.field_226100_d_ * ta02 + this.field_226102_f_ * ta22;
        float a20 = this.field_226103_g_ * ta00 + this.field_226105_i_ * ta20;
        float a22 = this.field_226103_g_ * ta02 + this.field_226105_i_ * ta22;
        this.field_226097_a_ = a00;
        this.field_226099_c_ = a02;
        this.field_226100_d_ = a10;
        this.field_226102_f_ = a12;
        this.field_226103_g_ = a20;
        this.field_226105_i_ = a22;
    }

    private void rotateZ(Quaternion quaternion) {
        float z = quaternion.func_195893_c();
        float w = quaternion.func_195894_d();
        float zz = 2.0f * z * z;
        float ta00 = 1.0f - zz;
        float ta11 = 1.0f - zz;
        float zw = z * w;
        float ta10 = 2.0f * (0.0f + zw);
        float ta01 = 2.0f * (0.0f - zw);
        float a00 = this.field_226097_a_ * ta00 + this.field_226098_b_ * ta10;
        float a01 = this.field_226097_a_ * ta01 + this.field_226098_b_ * ta11;
        float a10 = this.field_226100_d_ * ta00 + this.field_226101_e_ * ta10;
        float a11 = this.field_226100_d_ * ta01 + this.field_226101_e_ * ta11;
        float a20 = this.field_226103_g_ * ta00 + this.field_226104_h_ * ta10;
        float a21 = this.field_226103_g_ * ta01 + this.field_226104_h_ * ta11;
        this.field_226097_a_ = a00;
        this.field_226098_b_ = a01;
        this.field_226100_d_ = a10;
        this.field_226101_e_ = a11;
        this.field_226103_g_ = a20;
        this.field_226104_h_ = a21;
    }

    private void rotateXYZ(Quaternion quaternion) {
        float x = quaternion.func_195889_a();
        float y = quaternion.func_195891_b();
        float z = quaternion.func_195893_c();
        float w = quaternion.func_195894_d();
        float xx = 2.0f * x * x;
        float yy = 2.0f * y * y;
        float zz = 2.0f * z * z;
        float ta00 = 1.0f - yy - zz;
        float ta11 = 1.0f - zz - xx;
        float ta22 = 1.0f - xx - yy;
        float xy = x * y;
        float yz = y * z;
        float zx = z * x;
        float xw = x * w;
        float yw = y * w;
        float zw = z * w;
        float ta10 = 2.0f * (xy + zw);
        float ta01 = 2.0f * (xy - zw);
        float ta20 = 2.0f * (zx - yw);
        float ta02 = 2.0f * (zx + yw);
        float ta21 = 2.0f * (yz + xw);
        float ta12 = 2.0f * (yz - xw);
        float a00 = this.field_226097_a_ * ta00 + this.field_226098_b_ * ta10 + this.field_226099_c_ * ta20;
        float a01 = this.field_226097_a_ * ta01 + this.field_226098_b_ * ta11 + this.field_226099_c_ * ta21;
        float a02 = this.field_226097_a_ * ta02 + this.field_226098_b_ * ta12 + this.field_226099_c_ * ta22;
        float a10 = this.field_226100_d_ * ta00 + this.field_226101_e_ * ta10 + this.field_226102_f_ * ta20;
        float a11 = this.field_226100_d_ * ta01 + this.field_226101_e_ * ta11 + this.field_226102_f_ * ta21;
        float a12 = this.field_226100_d_ * ta02 + this.field_226101_e_ * ta12 + this.field_226102_f_ * ta22;
        float a20 = this.field_226103_g_ * ta00 + this.field_226104_h_ * ta10 + this.field_226105_i_ * ta20;
        float a21 = this.field_226103_g_ * ta01 + this.field_226104_h_ * ta11 + this.field_226105_i_ * ta21;
        float a22 = this.field_226103_g_ * ta02 + this.field_226104_h_ * ta12 + this.field_226105_i_ * ta22;
        this.field_226097_a_ = a00;
        this.field_226098_b_ = a01;
        this.field_226099_c_ = a02;
        this.field_226100_d_ = a10;
        this.field_226101_e_ = a11;
        this.field_226102_f_ = a12;
        this.field_226103_g_ = a20;
        this.field_226104_h_ = a21;
        this.field_226105_i_ = a22;
    }
}

