/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.debug;

import com.google.common.collect.Lists;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import net.minecraft.client.gui.overlay.DebugOverlayGui;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={DebugOverlayGui.class})
public abstract class MixinDebugHud {
    @Shadow
    private static long func_175240_a(long bytes) {
        throw new UnsupportedOperationException();
    }

    @Redirect(method={"getRightText"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Lists;newArrayList([Ljava/lang/Object;)Ljava/util/ArrayList;"))
    private ArrayList<String> redirectRightTextEarly(Object[] elements) {
        ArrayList strings = Lists.newArrayList((Object[])((String[])elements));
        strings.add("");
        strings.add("Rubidium Renderer");
        strings.add(TextFormatting.UNDERLINE + MixinDebugHud.getFormattedVersionText());
        strings.add("");
        strings.addAll(MixinDebugHud.getChunkRendererDebugStrings());
        if (SodiumClientMod.options().advanced.ignoreDriverBlacklist) {
            strings.add(TextFormatting.RED + "(!!) Driver blacklist ignored");
        }
        for (int i = 0; i < strings.size(); ++i) {
            String str = (String)strings.get(i);
            if (!str.startsWith("Allocated:")) continue;
            strings.add(i + 1, MixinDebugHud.getNativeMemoryString());
            break;
        }
        return strings;
    }

    private static String getFormattedVersionText() {
        String version = SodiumClientMod.getVersion();
        TextFormatting color = version.endsWith("-dirty") ? TextFormatting.RED : (version.contains("+rev.") ? TextFormatting.LIGHT_PURPLE : TextFormatting.GREEN);
        return color + version;
    }

    private static List<String> getChunkRendererDebugStrings() {
        ChunkRenderBackend<?> backend = SodiumWorldRenderer.getInstance().getChunkRenderer();
        ArrayList<String> strings = new ArrayList<String>(4);
        strings.add("Chunk Renderer: " + backend.getRendererName());
        strings.addAll(backend.getDebugStrings());
        return strings;
    }

    private static String getNativeMemoryString() {
        return "Off-Heap: +" + MixinDebugHud.func_175240_a(ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed()) + "MB";
    }
}

