/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.forge;

import java.awt.Rectangle;
import java.util.List;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.api.event.WailaRenderEvent;
import mcp.mobius.waila.api.event.WailaTooltipEvent;
import mcp.mobius.waila.forge.ForgeTickHandler;
import mcp.mobius.waila.gui.GuiConfigHome;
import mcp.mobius.waila.overlay.DataAccessor;
import mcp.mobius.waila.overlay.Tooltip;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="waila", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ForgeWailaClient
extends WailaClient {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        keyBindingBuilder = (id, key) -> {
            KeyBinding keyBinding = new KeyBinding("key.waila." + id, (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputMappings.Type.KEYSYM, key.intValue(), "WTHIT");
            ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
            return keyBinding;
        };
        ForgeWailaClient.init();
        ForgeWailaClient.registerConfigScreen();
        Tooltip.onPreRender = rect -> {
            WailaRenderEvent.Pre preEvent = new WailaRenderEvent.Pre(DataAccessor.INSTANCE, (Rectangle)rect);
            if (MinecraftForge.EVENT_BUS.post((Event)preEvent)) {
                return null;
            }
            return preEvent.getPosition();
        };
        Tooltip.onPostRender = position -> MinecraftForge.EVENT_BUS.post((Event)new WailaRenderEvent.Post((Rectangle)position));
        Tooltip.onCreate = texts -> MinecraftForge.EVENT_BUS.post((Event)new WailaTooltipEvent((List<ITextComponent>)texts, DataAccessor.INSTANCE));
        ForgeTickHandler.registerListener();
    }

    static void registerConfigScreen() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, screen) -> new GuiConfigHome((Screen)screen));
    }

    @Mod(value="wthit")
    @Mod.EventBusSubscriber(modid="wthit", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class HahaBorgeGoBrrrr {
        @SubscribeEvent
        static void clientSetup(FMLClientSetupEvent event) {
            ForgeWailaClient.registerConfigScreen();
        }
    }

    @Mod.EventBusSubscriber(modid="waila", value={Dist.CLIENT})
    static class Subscriber {
        Subscriber() {
        }

        @SubscribeEvent
        static void entityJoinWorld(EntityJoinWorldEvent event) {
            if (event.getEntity() instanceof ClientPlayerEntity) {
                ForgeWailaClient.onJoinServer();
            }
        }

        @SubscribeEvent
        static void renderGameOverlay(RenderGameOverlayEvent.Post event) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                Tooltip.render(event.getMatrixStack(), event.getPartialTicks());
            }
        }

        @SubscribeEvent
        static void clientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                ForgeWailaClient.onClientTick();
            }
        }

        @SubscribeEvent
        static void itemTooltip(ItemTooltipEvent event) {
            ForgeWailaClient.onItemTooltip(event.getItemStack(), event.getToolTip());
        }
    }
}

