/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import mcp.mobius.waila.gui.config.OptionsListWidget;
import mcp.mobius.waila.gui.config.value.OptionsEntryValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class GuiOptions
extends Screen {
    private final Screen parent;
    private final Runnable saver;
    private final Runnable canceller;
    private OptionsListWidget options;

    public GuiOptions(Screen parent, ITextComponent title, Runnable saver, Runnable canceller) {
        super(title);
        this.parent = parent;
        this.saver = saver;
        this.canceller = canceller;
    }

    public GuiOptions(Screen parent, ITextComponent title) {
        this(parent, title, null, null);
    }

    public void func_231158_b_(Minecraft client, int width, int height) {
        super.func_231158_b_(client, width, height);
        this.options = this.getOptions();
        this.field_230705_e_.add(this.options);
        this.func_231035_a_((IGuiEventListener)this.options);
        if (this.saver != null && this.canceller != null) {
            this.func_230480_a_((Widget)new Button(width / 2 - 100, height - 25, 100, 20, (ITextComponent)new TranslationTextComponent("gui.done"), w -> {
                this.options.save();
                this.saver.run();
                this.func_231175_as__();
            }));
            this.func_230480_a_((Widget)new Button(width / 2 + 5, height - 25, 100, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), w -> {
                this.canceller.run();
                this.func_231175_as__();
            }));
        } else {
            this.func_230480_a_((Widget)new Button(width / 2 - 50, height - 25, 100, 20, (ITextComponent)new TranslationTextComponent("gui.done"), w -> {
                this.options.save();
                this.func_231175_as__();
            }));
        }
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrices);
        this.options.func_230430_a_(matrices, mouseX, mouseY, partialTicks);
        GuiOptions.func_238471_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (String)this.field_230704_d_.getString(), (int)(this.field_230708_k_ / 2), (int)12, (int)0xFFFFFF);
        super.func_230430_a_(matrices, mouseX, mouseY, partialTicks);
        if (mouseY < 32 || mouseY > this.field_230709_l_ - 32) {
            return;
        }
        this.options.func_212930_a(mouseX, mouseY).ifPresent(element -> {
            OptionsEntryValue value;
            if (element instanceof OptionsEntryValue && I18n.func_188566_a((String)(value = (OptionsEntryValue)((Object)element)).getDescription())) {
                int valueX = value.getX() + 10;
                String title = value.getTitle().getString();
                if (mouseX < valueX || mouseX > valueX + this.field_230712_o_.func_78256_a(title)) {
                    return;
                }
                ArrayList tooltip = Lists.newArrayList((Object[])new IReorderingProcessor[]{new StringTextComponent(title).func_241878_f()});
                tooltip.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent(value.getDescription()).func_240699_a_(TextFormatting.GRAY), 200));
                this.func_238654_b_(matrices, tooltip, mouseX, mouseY);
            }
        });
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(this.parent);
    }

    public void addListener(IGuiEventListener listener) {
        this.field_230705_e_.add(listener);
    }

    public abstract OptionsListWidget getOptions();
}

