/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.google.common.collect.Maps;
import java.util.Map;

public enum IconUI {
    HEART(52, 0, 9, 9, 16, 0, 9, 9, "a"),
    HALF_HEART(61, 0, 9, 9, 16, 0, 9, 9, "b"),
    EMPTY_HEART(16, 0, 9, 9, "c"),
    EXPERIENCE_BUBBLE(25, 18, 9, 9, "x");

    private static final Map<String, IconUI> ELEMENTS;
    public final int u;
    public final int v;
    public final int su;
    public final int sv;
    public final int bu;
    public final int bv;
    public final int bsu;
    public final int bsv;
    public final String symbol;

    private IconUI(int u, int v, int su, int sv, String symbol) {
        this(u, v, su, sv, -1, -1, -1, -1, symbol);
    }

    private IconUI(int u, int v, int su, int sv, int bu, int bv, int bsu, int bsv, String symbol) {
        this.u = u;
        this.v = v;
        this.su = su;
        this.sv = sv;
        this.bu = bu;
        this.bv = bv;
        this.bsu = bsu;
        this.bsv = bsv;
        this.symbol = symbol;
    }

    public static IconUI bySymbol(String s) {
        return ELEMENTS.getOrDefault(s, EXPERIENCE_BUBBLE);
    }

    static {
        ELEMENTS = Maps.newHashMap();
        for (IconUI icon : IconUI.values()) {
            ELEMENTS.put(icon.symbol, icon);
        }
    }
}

