/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import java.util.List;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import mcp.mobius.waila.overlay.DataAccessor;
import mcp.mobius.waila.overlay.TooltipRegistrar;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class Raycast {
    private static RayTraceResult target = null;

    public static void fire() {
        Minecraft client = Minecraft.func_71410_x();
        Entity viewpoint = client.func_175606_aa();
        if (viewpoint == null) {
            return;
        }
        target = Raycast.raycast(viewpoint, client.field_71442_b.func_78757_d(), client.func_184121_ak());
    }

    public static RayTraceResult getTarget() {
        return target;
    }

    public static RayTraceResult raycast(Entity entity, double playerReach, float tickDelta) {
        EntityRayTraceResult result;
        World world = entity.field_70170_p;
        Vector3d eyePosition = entity.func_174824_e(tickDelta);
        Vector3d lookVector = entity.func_70676_i(tickDelta);
        Vector3d traceEnd = eyePosition.func_72441_c(lookVector.field_72450_a * playerReach, lookVector.field_72448_b * playerReach, lookVector.field_72449_c * playerReach);
        if (PluginConfig.INSTANCE.get(WailaConstants.CONFIG_SHOW_ENTITY) && (result = ProjectileHelper.func_221269_a((World)world, (Entity)entity, (Vector3d)eyePosition, (Vector3d)traceEnd, (AxisAlignedBB)new AxisAlignedBB(eyePosition, traceEnd), null)) != null) {
            return result;
        }
        RayTraceContext.FluidMode fluidView = PluginConfig.INSTANCE.get(WailaConstants.CONFIG_SHOW_FLUID) ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE;
        RayTraceContext context = new RayTraceContext(eyePosition, traceEnd, RayTraceContext.BlockMode.OUTLINE, fluidView, entity);
        return world.func_217299_a(context);
    }

    public static ItemStack getDisplayItem() {
        if (target == null) {
            return ItemStack.field_190927_a;
        }
        TooltipRegistrar registrar = TooltipRegistrar.INSTANCE;
        DataAccessor data = DataAccessor.INSTANCE;
        PluginConfig config = PluginConfig.INSTANCE;
        if (target.func_216346_c() == RayTraceResult.Type.ENTITY) {
            List<IEntityComponentProvider> providers = registrar.entityItem.get(data.getEntity());
            for (IEntityComponentProvider provider : providers) {
                ItemStack providerStack = provider.getDisplayItem(data, config);
                if (providerStack.func_190926_b()) continue;
                return providerStack;
            }
        } else {
            ItemStack itemStack;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            BlockPos pos = ((BlockRayTraceResult)target).func_216350_a();
            BlockState state = data.getBlockState();
            if (state.func_196958_f()) {
                return ItemStack.field_190927_a;
            }
            List<IBlockComponentProvider> providers = registrar.blockItem.get(state.func_177230_c());
            for (IBlockComponentProvider iBlockComponentProvider : providers) {
                ItemStack providerStack = iBlockComponentProvider.getDisplayItem(data, config);
                if (providerStack.func_190926_b()) continue;
                return providerStack;
            }
            TileEntity blockEntity = data.getBlockEntity();
            if (blockEntity != null) {
                providers = registrar.blockItem.get(blockEntity);
                for (IBlockComponentProvider provider : providers) {
                    ItemStack providerStack = provider.getDisplayItem(data, config);
                    if (providerStack.func_190926_b()) continue;
                    return providerStack;
                }
            }
            if (!(itemStack = state.func_177230_c().func_185473_a((IBlockReader)world, pos, state)).func_190926_b()) {
                return itemStack;
            }
            if (state.func_177230_c().func_199767_j() != Items.field_190931_a) {
                return new ItemStack((IItemProvider)state.func_177230_c());
            }
        }
        return ItemStack.field_190927_a;
    }

    public static Entity getOverrideEntity() {
        if (target == null || target.func_216346_c() != RayTraceResult.Type.ENTITY) {
            return null;
        }
        TooltipRegistrar registrar = TooltipRegistrar.INSTANCE;
        Entity entity = ((EntityRayTraceResult)target).func_216348_a();
        List<IEntityComponentProvider> overrideProviders = registrar.entityOverride.get(entity);
        for (IEntityComponentProvider provider : overrideProviders) {
            Entity override = provider.getOverride(DataAccessor.INSTANCE, PluginConfig.INSTANCE);
            if (override == null) continue;
            return override;
        }
        return entity;
    }

    public static BlockState getOverrideBlock() {
        if (target == null || target.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return Blocks.field_150350_a.func_176223_P();
        }
        TooltipRegistrar registrar = TooltipRegistrar.INSTANCE;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = ((BlockRayTraceResult)target).func_216350_a();
        BlockState state = world.func_180495_p(pos);
        List<IBlockComponentProvider> providers = registrar.blockOverride.get(state.func_177230_c());
        for (IBlockComponentProvider provider : providers) {
            BlockState override = provider.getOverride(DataAccessor.INSTANCE, PluginConfig.INSTANCE);
            if (override == null) continue;
            return override;
        }
        TileEntity blockEntity = world.func_175625_s(pos);
        providers = registrar.blockOverride.get(blockEntity);
        for (IBlockComponentProvider provider : providers) {
            BlockState override = provider.getOverride(DataAccessor.INSTANCE, PluginConfig.INSTANCE);
            if (override == null) continue;
            return override;
        }
        return state;
    }
}

