/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.mixin.AccessorBossBarHud;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.overlay.DrawableText;
import mcp.mobius.waila.utils.TaggableList;
import mcp.mobius.waila.utils.TaggedText;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class Tooltip {
    public static Consumer<List<ITextComponent>> onCreate;
    public static Function<Rectangle, Rectangle> onPreRender;
    public static Consumer<Rectangle> onPostRender;
    static boolean shouldRender;
    private static final TaggableList<ResourceLocation, ITextComponent> LINES;
    private static final Object2IntOpenHashMap<ITextComponent> LINE_HEIGHT;
    private static final LazyValue<Rectangle> RENDER_RECT;
    private static final LazyValue<Rectangle> RECT;
    private static ItemStack stack;
    private static int topOffset;
    private static boolean started;

    public static void start() {
        LINES.clear();
        LINE_HEIGHT.clear();
        stack = ItemStack.field_190927_a;
        topOffset = 0;
        started = true;
    }

    public static void addLines(List<ITextComponent> lines) {
        Preconditions.checkState((boolean)started);
        lines.forEach(text -> {
            if (text instanceof TaggedText) {
                ResourceLocation tag = ((TaggedText)((Object)text)).getTag();
                LINES.setTag(tag, (ITextComponent)((TaggableList)lines).getTag(tag));
            } else {
                LINES.add(text);
            }
        });
    }

    public static void addLine(ITextComponent line) {
        LINES.add(line);
    }

    public static void setStack(ItemStack stack) {
        Preconditions.checkState((boolean)started);
        Tooltip.stack = PluginConfig.INSTANCE.get(WailaConstants.CONFIG_SHOW_ITEM) ? stack : ItemStack.field_190927_a;
    }

    public static void finish() {
        Preconditions.checkState((boolean)started);
        onCreate.accept(LINES);
        Minecraft client = Minecraft.func_71410_x();
        MainWindow window = client.func_228018_at_();
        float scale = Waila.CONFIG.get().getOverlay().getScale();
        WailaConfig.ConfigOverlay.Position pos = Waila.CONFIG.get().getOverlay().getPosition();
        int w = 0;
        int h = 0;
        for (ITextComponent line : LINES) {
            int lineH;
            int lineW;
            if (line instanceof DrawableText) {
                Dimension size = ((DrawableText)line).getSize();
                lineW = size.width;
                lineH = size.height;
            } else {
                ITextComponent text = line instanceof TaggedText ? LINES.getTag(((TaggedText)line).getTag()) : line;
                FontRenderer textRenderer = Minecraft.func_71410_x().field_71466_p;
                lineW = textRenderer.func_238414_a_((ITextProperties)text);
                Objects.requireNonNull(textRenderer);
                lineH = 9 + 1;
            }
            w = Math.max(w, lineW);
            h += lineH;
            LINE_HEIGHT.put((Object)line, lineH);
        }
        topOffset = 0;
        if (!stack.func_190926_b()) {
            if (h < 16) {
                topOffset = (16 - h) / 2;
            }
            w = Math.max(w, 16) + 20;
            h = Math.max(h, 16);
        }
        w += 10;
        h += 8;
        int windowW = (int)((float)window.func_198107_o() / scale);
        int windowH = (int)((float)window.func_198087_p() / scale);
        WailaConfig.ConfigOverlay.Position.HorizontalAlignment anchorX = pos.getAnchorX();
        WailaConfig.ConfigOverlay.Position.VerticalAlignment anchorY = pos.getAnchorY();
        WailaConfig.ConfigOverlay.Position.HorizontalAlignment alignX = pos.getAlignX();
        WailaConfig.ConfigOverlay.Position.VerticalAlignment alignY = pos.getAlignY();
        double x = (double)windowW * anchorX.multiplier - (double)w * alignX.multiplier + (double)pos.getX();
        double y = (double)windowH * anchorY.multiplier - (double)h * alignY.multiplier + (double)pos.getY();
        if (anchorX == WailaConfig.ConfigOverlay.Position.HorizontalAlignment.CENTER && anchorY == WailaConfig.ConfigOverlay.Position.VerticalAlignment.TOP) {
            y += (double)(((AccessorBossBarHud)client.field_71456_v.func_184046_j()).getBossBars().size() * 19);
        }
        ((Rectangle)RECT.func_179281_c()).setRect(x, y, w, h);
        started = false;
    }

    public static void render(MatrixStack matrices, float delta) {
        if (!shouldRender) {
            return;
        }
        Minecraft client = Minecraft.func_71410_x();
        IProfiler profiler = client.func_213239_aq();
        WailaConfig config = Waila.CONFIG.get();
        profiler.func_76320_a("Waila Overlay");
        RenderSystem.pushMatrix();
        float scale = config.getOverlay().getScale();
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        DisplayUtil.enable2DRender();
        Rectangle rect = (Rectangle)RENDER_RECT.func_179281_c();
        rect.setRect((Rectangle2D)RECT.func_179281_c());
        rect = onPreRender.apply(rect);
        if (rect == null) {
            RenderSystem.enableDepthTest();
            RenderSystem.popMatrix();
            profiler.func_76319_b();
            return;
        }
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        WailaConfig.ConfigOverlay.ConfigOverlayColor color = config.getOverlay().getColor();
        int bg = color.getBackgroundColor();
        int gradStart = color.getGradientStart();
        int gradEnd = color.getGradientEnd();
        DisplayUtil.drawGradientRect(matrices, x + 1, y, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + h, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 1, w - 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + w, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 2, 1, h - 3, gradStart, gradEnd);
        DisplayUtil.drawGradientRect(matrices, x + w - 1, y + 2, 1, h - 3, gradStart, gradEnd);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 1, w - 1, 1, gradStart, gradStart);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + h - 1, w - 1, 1, gradEnd, gradEnd);
        if (!stack.func_190926_b()) {
            DisplayUtil.renderStack(x + 5, y + h / 2 - 8, stack, "");
            x += 20;
        }
        x += 6;
        y += 6 + topOffset;
        RenderSystem.enableBlend();
        for (ITextComponent line : LINES) {
            if (line instanceof DrawableText) {
                ((DrawableText)line).render(matrices, x, y, delta);
            } else {
                FontRenderer textRenderer = client.field_71466_p;
                ITextComponent text = line instanceof TaggedText ? LINES.getTag(((TaggedText)line).getTag()) : line;
                textRenderer.func_243246_a(matrices, text, (float)x, (float)y, color.getFontColor());
            }
            y += LINE_HEIGHT.getInt((Object)line);
        }
        RenderSystem.disableBlend();
        onPostRender.accept(rect);
        RenderSystem.enableDepthTest();
        RenderSystem.popMatrix();
        profiler.func_76319_b();
    }

    static {
        shouldRender = false;
        LINES = new TaggableList<ResourceLocation, ITextComponent>(TaggedText::new);
        LINE_HEIGHT = new Object2IntOpenHashMap();
        RENDER_RECT = new LazyValue(Rectangle::new);
        RECT = new LazyValue(Rectangle::new);
        stack = ItemStack.field_190927_a;
        topOffset = 0;
        started = false;
    }
}

