/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IDrawableText;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.plugin.core.WailaCore;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public enum EntityComponent implements IEntityComponentProvider
{
    INSTANCE;


    @Override
    public void appendHead(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        Entity entity = accessor.getEntity();
        ((ITaggableList)tooltip).setTag(WailaConstants.OBJECT_NAME_TAG, new StringTextComponent(String.format(accessor.getEntityNameFormat(), entity.func_145748_c_().getString())));
        if (config.get(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            ((ITaggableList)tooltip).setTag(WailaConstants.REGISTRY_NAME_TAG, new StringTextComponent(String.format(accessor.getRegistryNameFormat(), Registry.field_212629_r.func_177774_c((Object)entity.func_200600_R()))));
        }
    }

    @Override
    public void appendBody(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.get(WailaCore.CONFIG_SHOW_ENTITY_HEALTH) && accessor.getEntity() instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)accessor.getEntity();
            float health = living.func_110143_aJ();
            float maxHealth = living.func_110138_aP();
            if (living.func_110138_aP() > (float)Waila.CONFIG.get().getGeneral().getMaxHealthForRender()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.health", new Object[]{String.format("%.2f", Float.valueOf(health)), String.format("%.2f", Float.valueOf(maxHealth))}));
            } else {
                CompoundNBT healthData = new CompoundNBT();
                healthData.func_74776_a("health", health / 2.0f);
                healthData.func_74776_a("max", maxHealth / 2.0f);
                tooltip.add((ITextComponent)IDrawableText.of(WailaCore.RENDER_ENTITY_HEALTH, healthData));
            }
        }
    }

    @Override
    public void appendTail(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.get(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            ((ITaggableList)tooltip).setTag(WailaConstants.MOD_NAME_TAG, new StringTextComponent(String.format(Waila.CONFIG.get().getFormatting().getModName(), ModIdentification.getModInfo(accessor.getEntity()).getName())));
        }
    }
}

