/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.api.option.KeyedEnum;
import journeymap.client.ui.component.DropDownButton;
import journeymap.client.ui.component.DropDownItem;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.common.properties.config.ConfigField;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;

public class PropertyDropdownButton<T>
extends DropDownButton
implements IConfigFieldHolder<ConfigField<T>> {
    protected final ConfigField<T> field;
    protected final String baseLabel;
    protected final String glyph = "\u21d5";
    protected final String labelPattern = "%1$s : %2$s %3$s %2$s";
    private final Collection<T> values;
    protected Button.IPressable pressable;

    public PropertyDropdownButton(Collection<T> values, String label, ConfigField<T> field, Button.IPressable pressable) {
        super("", pressable);
        this.pressable = pressable;
        this.field = field;
        this.baseLabel = label;
        this.values = values;
        this.setValue(field.get());
        this.disabledLabelColor = 0x404040;
        List<DropDownItem> items = this.setItems(values);
        super.setItems(items);
        this.setRenderDecorations(true);
        this.setRenderSolidBackground(true);
    }

    public PropertyDropdownButton(Collection<T> values, String label, ConfigField<T> field) {
        this(values, label, field, PropertyDropdownButton.emptyPressable());
    }

    protected List<DropDownItem> setItems(Collection<T> values) {
        ArrayList items = Lists.newArrayList();
        values.forEach(value -> {
            String label = value instanceof KeyedEnum ? Constants.getString(((KeyedEnum)value).getKey()) : Constants.getString(value.toString());
            items.add(new DropDownItem(this, value, label));
        });
        return items;
    }

    @Override
    public void setSelected(DropDownItem selected) {
        this.selected = selected;
        this.setValue(selected.getId());
        this.field_230697_t_.onPress((Button)selected);
    }

    public void setValue(T value) {
        if (!this.field.get().equals(value)) {
            this.field.set((Object)value);
            this.field.save();
        }
        String label = value instanceof KeyedEnum ? Constants.getString(((KeyedEnum)value).getKey()) : Constants.getString(value.toString());
        this.func_238482_a_((ITextComponent)Constants.getStringTextComponent(this.getFormattedLabel(label)));
    }

    public ConfigField<T> getField() {
        return this.field;
    }

    @Override
    public int getFitWidth(FontRenderer fr) {
        int max = fr.func_78256_a(this.func_230458_i_().getString());
        for (DropDownItem item : this.items) {
            max = Math.max(max, fr.func_78256_a(this.getFormattedLabel(item.getLabel())));
        }
        return max + this.buttonBuffer;
    }

    @Override
    public int func_230998_h_() {
        return this.field_230688_j_;
    }

    @Override
    public void func_230991_b_(int width) {
        if (this.paneScreen != null) {
            this.paneScreen.setPaneWidth(width);
        }
        super.func_230991_b_(width);
    }

    @Override
    protected String getLabel(DropDownItem item) {
        return this.getFormattedLabel(item.getLabel());
    }

    protected String getFormattedLabel(String value) {
        return String.format("%1$s : %2$s %3$s %2$s", this.baseLabel, "\u21d5", value);
    }

    @Override
    public void refresh() {
        this.setValue(this.field.get());
    }

    @Override
    public ConfigField<T> getConfigField() {
        return this.field;
    }
}

