/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.world;

import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import javax.annotation.Nullable;
import journeymap.client.data.DataCache;
import journeymap.client.model.ChunkMD;
import journeymap.common.helper.DimensionHelper;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;

@MethodsReturnNonnullByDefault
public enum JmBlockAccess implements IBlockDisplayReader
{
    INSTANCE;


    public TileEntity func_175625_s(@NotNull BlockPos pos) {
        return this.getWorld().func_175625_s(pos);
    }

    public BlockState func_180495_p(@NotNull BlockPos pos) {
        if (!this.isValid(pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        ChunkMD chunkMD = this.getChunkMDFromBlockCoords(pos);
        if (chunkMD != null && chunkMD.hasChunk()) {
            return chunkMD.getChunk().func_180495_p(new BlockPos(pos.func_177958_n() & 0xF, pos.func_177956_o(), pos.func_177952_p() & 0xF));
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public FluidState func_204610_c(@NotNull BlockPos blockPos) {
        return this.getWorld().func_204610_c(blockPos);
    }

    public int func_217298_h(@NotNull BlockPos p_217298_1_) {
        return this.getWorld().func_217298_h(p_217298_1_);
    }

    public int func_201572_C() {
        return this.getWorld().func_201572_C();
    }

    public int func_217301_I() {
        return this.getWorld().func_217301_I();
    }

    public BlockRayTraceResult func_217299_a(RayTraceContext context) {
        return this.getWorld().func_217299_a(context);
    }

    @Nullable
    public BlockRayTraceResult func_217296_a(Vector3d vec3d, Vector3d vec3d_1, BlockPos blockPos, VoxelShape voxelShape, BlockState blockState) {
        return this.getWorld().func_217296_a(vec3d, vec3d_1, blockPos, voxelShape, blockState);
    }

    public Biome getBiome(BlockPos pos) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        return this.getBiome(pos, (Biome)world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_243576_d(Biomes.field_76772_c));
    }

    @Nullable
    public Biome getBiome(BlockPos pos, Biome defaultBiome) {
        IntegratedServer server;
        Biome biome;
        ChunkMD chunkMD = this.getChunkMDFromBlockCoords(pos);
        if (chunkMD != null && chunkMD.hasChunk() && (biome = chunkMD.getBiome(pos)) != null) {
            return biome;
        }
        if (Minecraft.func_71410_x().func_71356_B() && (server = Minecraft.func_71410_x().func_71401_C()) != null) {
            try {
                return server.func_71218_a(DimensionHelper.getDimension((Entity)Minecraft.func_71410_x().field_71439_g)).func_225526_b_(pos.func_177958_n() >> 2, pos.func_177956_o() >> 2, pos.func_177952_p() >> 2);
            }
            catch (Exception e) {
                return server.func_71218_a(DimensionHelper.getDimension((Entity)Minecraft.func_71410_x().field_71439_g)).func_226691_t_(pos);
            }
        }
        return defaultBiome;
    }

    public World getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    private boolean isValid(BlockPos pos) {
        return pos.func_177958_n() >= -30000000 && pos.func_177952_p() >= -30000000 && pos.func_177958_n() < 30000000 && pos.func_177952_p() < 30000000 && pos.func_177956_o() >= 0 && pos.func_177956_o() < 256;
    }

    @Nullable
    private ChunkMD getChunkMDFromBlockCoords(BlockPos pos) {
        return DataCache.INSTANCE.getChunkMD(new ChunkPos(pos));
    }

    public float func_230487_a_(@NotNull Direction p_230487_1_, boolean p_230487_2_) {
        return this.getWorld().func_230487_a_(p_230487_1_, p_230487_2_);
    }

    public WorldLightManager func_225524_e_() {
        return this.getWorld().func_225524_e_();
    }

    public int func_225525_a_(@NotNull BlockPos blockPos, ColorResolver colorResolver) {
        int i = Minecraft.func_71410_x().field_71474_y.field_205217_U;
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int i1 = 0;
        CubeCoordinateIterator cursor3d = new CubeCoordinateIterator(blockPos.func_177958_n() - i, blockPos.func_177956_o(), blockPos.func_177952_p() - i, blockPos.func_177958_n() + i, blockPos.func_177956_o(), blockPos.func_177952_p() + i);
        BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
        while (cursor3d.func_218301_a()) {
            blockpos$mutableblockpos.func_181079_c(cursor3d.func_218304_b(), cursor3d.func_218302_c(), cursor3d.func_218303_d());
            int j1 = colorResolver.getColor(this.getBiome((BlockPos)blockpos$mutableblockpos), (double)blockpos$mutableblockpos.func_177958_n(), (double)blockpos$mutableblockpos.func_177952_p());
            k += (j1 & 0xFF0000) >> 16;
            l += (j1 & 0xFF00) >> 8;
            i1 += j1 & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | i1 / j & 0xFF;
    }

    public int func_226658_a_(@NotNull LightType lightType, @NotNull BlockPos blockPos) {
        return this.getWorld().func_226658_a_(lightType, blockPos);
    }

    public int func_226659_b_(@NotNull BlockPos blockPosIn, int amount) {
        return this.getWorld().func_226659_b_(blockPosIn, amount);
    }

    public boolean func_226660_f_(@NotNull BlockPos blockPosIn) {
        return this.getWorld().func_226660_f_(blockPosIn);
    }
}

